<?php
require_once 'example-create-objects.php';
require_once 'XML/FastCreate.php';

// okrelamy podstawowe opcje dokumentu XML 
$options = array(
                 'encoding' => 'ISO-8859-1',
                 'standalone' => 'yes'
                );
// Pobieramy now instancj sterownika 'Text' 
$xml = XML_FastCreate::factory('Text', $options);

// Ta zmienna przechowuje wszystkie etykiety w postaci kodu XML
$labelsXML = '';

// Przegldamy etykiety albumw w tablicy
foreach ($labels as $label) {

   // Ta zmienna przechowuje wszystkich artystw danego studia (etykiety) jako XML
   $artistsXML = '';

   // Przegldamy wszystkich artystw
   foreach ($label->artists as $artist) {

      // Ta zmienna przechowuje wszystkie albumy danego artysty jako kod XML
      $records = '';

      // Przegldamy wszystkie albumy (records)
      foreach ($artist->records as $record) {
         $recordAtts = array(
                             'id' => $record->id,
                             'released' => $record->released
                           );
         // tworzymy i dodajemy jeden znacznik <record/>
         $records .= $xml->record($recordAtts, $xml->name(
                                                   $record->name));
      }
      $artistAtts = array('id' => $artist->id);
      // tworzymy i dodajemy jeden znacznik <artist/>
      $artistsXML .= $xml->artist($artistAtts,
                                         $xml->records($records));
   }
   $labelAtts = array('name' => $label->name);

   // tworzymy i dodajemy jeden znacznik <label/>
   $labelsXML .= $xml->label($labelAtts, $xml->artists($artistsXML));
}
$xml->labels($labelsXML);

// Wysyamy gotowy kod XML do standardowego strumienia wyjcia STDOUT
$xml->toXML();

?>