 #include "minunit.h"
 #include <lcthw/string_algos.h>
 #include <lcthw/bstrlib.h>
 #include <time.h>

 struct tagbstring IN_STR = bsStatic(
         "Mam ALPHA beta ALPHA i pomarańcze ALPHA");
 struct tagbstring ALPHA = bsStatic("ALPHA");
 const int TEST_TIME = 1;

 char *test_find_and_scan()
 {
     StringScanner *scan = StringScanner_create(&IN_STR);
     mu_assert(scan != NULL, "Nie udało się utworzyć skanera.");

     int find_i = String_find(&IN_STR, &ALPHA);
     mu_assert(find_i > 0, "Nie udało się odnaleźć 'ALPHA' w sprawdzanym ciągu tekstowym.");

     int scan_i = StringScanner_scan(scan, &ALPHA);
     mu_assert(scan_i > 0, "Nie udało się odnaleźć 'ALPHA' w trakcie skanowania.");
     mu_assert(scan_i == find_i, "Niedopasowane wartości find i scan.");

     scan_i = StringScanner_scan(scan, &ALPHA);
     mu_assert(scan_i > find_i,
         "Powinien być znaleziony kolejny ciąg tekstowy ALPHA po pierwszym.");

     scan_i = StringScanner_scan(scan, &ALPHA);
     mu_assert(scan_i > find_i,
         "Powinien być znaleziony kolejny ciąg tekstowy ALPHA po pierwszym.");

     mu_assert(StringScanner_scan(scan, &ALPHA) == -1,
         "Nie powinien być znaleziony.");

     StringScanner_destroy(scan);

     return NULL;
 }

 char *test_binstr_performance()
 {
     int i = 0;
     int found_at = 0;
     unsigned long find_count = 0;
     time_t elapsed = 0;
     time_t start = time(NULL);

     do {
         for (i = 0; i < 1000; i++) {
             found_at = binstr(&IN_STR, 0, &ALPHA);
             mu_assert(found_at != BSTR_ERR, "Nie udało się odnaleźć!");
             find_count++;
         }

         elapsed = time(NULL) - start;
     } while (elapsed <= TEST_TIME);

     debug("LICZBA WYSZUKIWAŃ BINARNYCH: %lu, CZAS TRWANIA: %d, LICZBA OPERACJI: %f",
         find_count, (int)elapsed, (double)find_count / elapsed);
     return NULL;
 }

 char *test_find_performance()
 {
     int i = 0;
     int found_at = 0;
     unsigned long find_count = 0;
     time_t elapsed = 0;
     time_t start = time(NULL);

     do {
         for (i = 0; i < 1000; i++) {
             found_at = String_find(&IN_STR, &ALPHA);
             find_count++;
         }

         elapsed = time(NULL) - start;
     } while (elapsed <= TEST_TIME);

     debug("LICZBA WYSZUKIWAŃ: %lu, CZAS TRWANIA: %d, LICZBA OPERACJI: %f",
         find_count, (int)elapsed, (double)find_count / elapsed);

     return NULL;
 }

 char *test_scan_performance()
 {
     int i = 0;
     int found_at = 0;
     unsigned long find_count = 0;
     time_t elapsed = 0;
     StringScanner *scan = StringScanner_create(&IN_STR);

     time_t start = time(NULL);

     do {
         for (i = 0; i < 1000; i++) {
             found_at = 0;

             do {
                 found_at = StringScanner_scan(scan, &ALPHA);
                 find_count++;
             } while (found_at != -1);
         }

         elapsed = time(NULL) - start;
     } while (elapsed <= TEST_TIME);

     debug("LICZBA SKANOWAŃ: %lu, CZAS TRWANIA: %d, LICZBA OPERACJI: %f",
         find_count, (int)elapsed, (double)find_count / elapsed);

     StringScanner_destroy(scan);

     return NULL;
 }

 char *all_tests()
 {
     mu_suite_start();

     mu_run_test(test_find_and_scan);

     // Poniższe polecenie pozwala na umieszczenie w komentarzu wskazanej sekcji kodu.
 #if 0
     mu_run_test(test_scan_performance);
     mu_run_test(test_find_performance);
     mu_run_test(test_binstr_performance);
 #endif

     return NULL;
 }

 RUN_TESTS(all_tests);
