 #include <stdio.h>
 #include <assert.h>
 #include <stdlib.h>
 #include <string.h>

 struct Person {
     char *name;
     int age;
     int height;
     int weight;
 };

 struct Person *Person_create(char *name, int age, int height,
         int weight)
 {
     struct Person *who = malloc(sizeof(struct Person));
     assert(who != NULL);

     who->name = strdup(name);
     who->age = age;
     who->height = height;
     who->weight = weight;

     return who;
 }

 void Person_destroy(struct Person *who)
 {
     assert(who != NULL);

     free(who->name);
     free(who);
 }

 void Person_print(struct Person *who)
 {
     printf("Osoba: %s\n", who->name);
     printf("\tWiek: %d\n", who->age);
     printf("\tWzrost: %d\n", who->height);
     printf("\tWaga: %d\n", who->weight);
 }

 int main(int argc, char *argv[])
 {
     // Utworzenie dwóch struktur przedstawiających osoby.
     struct Person *joe = Person_create("Joe Alex", 32, 64, 140);

     struct Person *frank = Person_create("Frank Blank", 20, 72, 180);

     // Wyświetlenie informacji o osobach oraz miejscu ich przechowywania w pamięci.
     printf("Joe znajduje się w pamięci pod adresem %p:\n", joe);
     Person_print(joe);

     printf("Frank znajduje się w pamięci pod adresem %p:\n", frank);
     Person_print(frank);

     // Zwiększenie wieku każdej osoby o 20 lat i ponowne wyświetlenie informacji.
     joe->age += 20;
     joe->height -= 2;
     joe->weight += 40;
     Person_print(joe);

     frank->age += 20;
     frank->weight += 20;
     Person_print(frank);

     // Usunięcie obu struktur, aby można było przeprowadzić operacje porządkowe.
     Person_destroy(joe);
     Person_destroy(frank);

     return 0;
 }
