 #include "minunit.h"
 #include <lcthw/darray.h>

 static DArray *array = NULL;
 static int *val1 = NULL;
 static int *val2 = NULL;

 char *test_create()
 {
     array = DArray_create(sizeof(int), 100);
     mu_assert(array != NULL, "Wykonanie DArray_create() zakończyło się niepowodzeniem.");
     mu_assert(array->contents != NULL, "Nieprawidłowa zawartość tablicy dynamicznej.");
     mu_assert(array->end == 0, "Koniec nie znajduje się w odpowiednim miejscu.");
     mu_assert(array->element_size == sizeof(int),
         "Nieprawidłowa wielkość elementu.");
     mu_assert(array->max == 100, "Nieprawidłowa wielkość maksymalna na początku.");

     return NULL;
 }

 char *test_destroy()
 {
     DArray_destroy(array);

     return NULL;
 }

 char *test_new()
 {
     val1 = DArray_new(array);
     mu_assert(val1 != NULL, "Nie udało się utworzyć nowego elementu.");

     val2 = DArray_new(array);
     mu_assert(val2 != NULL, "Nie udało się utworzyć nowego elementu.");

     return NULL;
 }

 char *test_set()
 {
     DArray_set(array, 0, val1);
     DArray_set(array, 1, val2);

     return NULL;
 }

 char *test_get()
 {
     mu_assert(DArray_get(array, 0) == val1, "Nieprawidłowa pierwsza wartość.");
     mu_assert(DArray_get(array, 1) == val2, "Nieprawidłowa druga wartość.");

     return NULL;
 }

 char *test_remove()
 {
     int *val_check = DArray_remove(array, 0);
     mu_assert(val_check != NULL, "Wartość nie powinna być NULL.");
     mu_assert(*val_check == *val1, "Powinna być pobrana pierwsza wartość.");
     mu_assert(DArray_get(array, 0) == NULL, "Tablica powinna być usunięta.");
     DArray_free(val_check);

     val_check = DArray_remove(array, 1);
     mu_assert(val_check != NULL, "Wartość nie powinna być NULL.");
     mu_assert(*val_check == *val2, "Powinna być pobrana pierwsza wartość.");
     mu_assert(DArray_get(array, 1) == NULL, "Tablica powinna być usunięta.");
     DArray_free(val_check);

     return NULL;
 }

 char *test_expand_contract()
 {
     int old_max = array->max;
     DArray_expand(array);
     mu_assert((unsigned int)array->max == old_max + array->expand_rate,
         "Nieprawidłowa wielkość po rozszerzeniu tablicy.");

     DArray_contract(array);
     mu_assert((unsigned int)array->max == array->expand_rate + 1,
         "Powinna pozostać na poziomie co najmniej expand_rate.");

     DArray_contract(array);
     mu_assert((unsigned int)array->max == array->expand_rate + 1,
         "Powinna pozostać na poziomie co najmniej expand_rate.");

     return NULL;
 }

 char *test_push_pop()
 {
     int i = 0;
     for (i = 0; i < 1000; i++) {
         int *val = DArray_new(array);
         *val = i * 333;
         DArray_push(array, val);
     }

     mu_assert(array->max == 1201, "Nieprawidłowa wielkość maksymalna.");

     for (i = 999; i >= 0; i--) {
         int *val = DArray_pop(array);
         mu_assert(val != NULL, "Wartość nie powinna być NULL.");
         mu_assert(*val == i * 333, "Nieprawidłowa wartość.");
         DArray_free(val);
     }

     return NULL;
 }

 char *all_tests()
 {
     mu_suite_start();

     mu_run_test(test_create);
     mu_run_test(test_new);
     mu_run_test(test_set);
     mu_run_test(test_get);
     mu_run_test(test_remove);
     mu_run_test(test_expand_contract);
     mu_run_test(test_push_pop);
     mu_run_test(test_destroy);

     return NULL;
 }

 RUN_TESTS(all_tests);
