 #include "minunit.h"
 #include <lcthw/bstree.h>
 #include <assert.h>
 #include <lcthw/bstrlib.h>
 #include <stdlib.h>
 #include <time.h>

 BSTree *map = NULL;
 static int traverse_called = 0;
 struct tagbstring test1 = bsStatic("dane testowe 1");
 struct tagbstring test2 = bsStatic("dane testowe 2");
 struct tagbstring test3 = bsStatic("dane testowe 3");
 struct tagbstring expect1 = bsStatic("WARTOŚĆ 1");
 struct tagbstring expect2 = bsStatic("WARTOŚĆ 2");
 struct tagbstring expect3 = bsStatic("WARTOŚĆ 3");

 static int traverse_good_cb(BSTreeNode * node)
 {
     debug("KLUCZ: %s", bdata((bstring) node->key));
     traverse_called++;
     return 0;
 }

 static int traverse_fail_cb(BSTreeNode * node)
 {
     debug("KLUCZ: %s", bdata((bstring) node->key));
     traverse_called++;

     if (traverse_called == 2) {
         return 1;
     } else {
         return 0;
     }
 }

 char *test_create()
 {
     map = BSTree_create(NULL);
     mu_assert(map != NULL, "Nie udało się utworzyć mapy.");

     return NULL;
 }

 char *test_destroy()
 {
     BSTree_destroy(map);

     return NULL;
 }

 char *test_get_set()
 {
     int rc = BSTree_set(map, &test1, &expect1);
     mu_assert(rc == 0, "Nie udało się ustawić &test1");
     bstring result = BSTree_get(map, &test1);
     mu_assert(result == &expect1, "Nieprawidłowa wartość dla test1.");

     rc = BSTree_set(map, &test2, &expect2);
     mu_assert(rc == 0, "Nie udało się ustawić test2");
     result = BSTree_get(map, &test2);
     mu_assert(result == &expect2, "Nieprawidłowa wartość dla test2.");

     rc = BSTree_set(map, &test3, &expect3);
     mu_assert(rc == 0, "Nie udało się ustawić test3");
     result = BSTree_get(map, &test3);
     mu_assert(result == &expect3, "Nieprawidłowa wartość dla test3.");

     return NULL;
 }

 char *test_traverse()
 {
     int rc = BSTree_traverse(map, traverse_good_cb);
     mu_assert(rc == 0, "Nie udało się przejść.");
     mu_assert(traverse_called == 3, "Nieprawidłowa liczba przejść.");

     traverse_called = 0;
     rc = BSTree_traverse(map, traverse_fail_cb);
     mu_assert(rc == 1, "Nie udało się przejść.");
     mu_assert(traverse_called == 2, "Nieprawidłowa liczba przejść for fail.");

     return NULL;
 }

 char *test_delete()
 {
     bstring deleted = (bstring) BSTree_delete(map, &test1);
     mu_assert(deleted != NULL, "Otrzymano NULL podczas usuwania.");
     mu_assert(deleted == &expect1, "Powinno być test1.");
     bstring result = BSTree_get(map, &test1);
     mu_assert(result == NULL, "Powinien zostać usunięty.");

     deleted = (bstring) BSTree_delete(map, &test1);
     mu_assert(deleted == NULL, "Powinno być NULL podczas usuwania.");

     deleted = (bstring) BSTree_delete(map, &test2);
     mu_assert(deleted != NULL, "Otrzymano NULL podczas usuwania.");
     mu_assert(deleted == &expect2, "Powinno być test2.");
     result = BSTree_get(map, &test2);
     mu_assert(result == NULL, "Powinien zostać usunięty.");

     deleted = (bstring) BSTree_delete(map, &test3);
     mu_assert(deleted != NULL, "Otrzymano NULL podczas usuwania.");
     mu_assert(deleted == &expect3, "Powinno być test3.");
     result = BSTree_get(map, &test3);
     mu_assert(result == NULL, "Powinien zostać usunięty.");

     // Sprawdzenie próby usunięcia nieistniejących elementów.
     deleted = (bstring) BSTree_delete(map, &test3);
     mu_assert(deleted == NULL, "Powinno być NULL.");

     return NULL;
 }

 char *test_fuzzing()
 {
     BSTree *store = BSTree_create(NULL);
     int i = 0;
     int j = 0;
     bstring numbers[100] = { NULL };
     bstring data[100] = { NULL };
     srand((unsigned int)time(NULL));

     for (i = 0; i < 100; i++) {
         int num = rand();
         numbers[i] = bformat("%d", num);
         data[i] = bformat("data %d", num);
         BSTree_set(store, numbers[i], data[i]);
     }

     for (i = 0; i < 100; i++) {
         bstring value = BSTree_delete(store, numbers[i]);
         mu_assert(value == data[i],
             "Nie udało się usunąć odpowiedniej liczby elementów.");

         mu_assert(BSTree_delete(store, numbers[i]) == NULL,
             "Nic nie powinno być.");

         for (j = i + 1; j < 99 - i; j++) {
             bstring value = BSTree_get(store, numbers[j]);
             mu_assert(value == data[j],
                 "Nie udało się pobrać odpowiedniej liczby elementów.");
         }

         bdestroy(value);
         bdestroy(numbers[i]);
     }

     BSTree_destroy(store);

     return NULL;
 }

 char *all_tests()
 {
     mu_suite_start();

     mu_run_test(test_create);
     mu_run_test(test_get_set);
     mu_run_test(test_traverse);
     mu_run_test(test_delete);
     mu_run_test(test_destroy);
     mu_run_test(test_fuzzing);

     return NULL;
 }

 RUN_TESTS(all_tests);
