
//
// To jest przykadowy kod z podrozdziau 25.5.4 Manipulowanie bitami ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

//------------------------------------------------------------------------------

void f(short val)    // Przyjmuje 16-bitow czyli 2-bajtow liczb cakowit typu short.
{
    unsigned char left = val&0xff;        // Pierwszy bajt z lewej (najmniej znaczcy).
    unsigned char right = (val>>8)&0xff;  // Pierwszy bajt z prawej (najbardziej znaczcy).
    // ...
    bool negative = val&0x800;            // bit znaku
    // ...
}

//------------------------------------------------------------------------------

// Do nadawania nazw bitom czsto wykorzystuje si wyliczenia.
enum Printer_flags {
    acknowledge=1,
    paper_empty=1<<1,
    busy=1<<2,
    out_of_black=1<<3,
    out_of_color=1<<4, 
    // ...
};

//------------------------------------------------------------------------------

int main()
{
    unsigned char x = out_of_color | out_of_black; // x otrzymuje warto 24 (16+8)
    x |= paper_empty;                              // x otrzymuje warto 26 (24+2)

    if (x& out_of_color) {                         // Czy bit out_of_color jest ustawiony? Tak.
        // ... 
    }

    // Nadal mona uywa operatora & do maskowania

    unsigned char y = x &(out_of_color | out_of_black); // x otrzymuje warto 12

    Printer_flags z = Printer_flags(out_of_color | out_of_black); // Rzutowanie jest konieczne.
}

//------------------------------------------------------------------------------
