
//
// To jest przykadowy kod z podrozdziau 19.3.1 Typy jako parametry szablonw ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include <string>

using std::string;

//------------------------------------------------------------------------------

// Prawie prawdziwy wektor elementw typu T:
template<class T> class vector {      // Czytaj: dla wszystkich typw T (tak jak w matematyce).
    int sz;                           // rozmiar
    T* elem;                          // wskanik na elementy
    int space;                        // size+free_space
public:
    vector() : sz(0), elem(0), space(0) { }    
    vector(int s);

    vector(const vector&);            // konstrruktor kopiujcy
    vector& operator=(const vector&); // przypisanie kopiujce

    ~vector() { delete[ ] elem; }     // destruktor

    T& operator[ ] (int n) { return elem[n]; } // dostp: zwraca referencj
    const T& operator[ ] (int n) const { return elem[n]; }  

    int size() const { return sz; }   // aktualny rozmiar
    int capacity() const { return space; }

    void resize(int newsize);         // wzrost
    void push_back(const T& d);
    void reserve(int newalloc);
};

//------------------------------------------------------------------------------


int main()
{
    vector<double> vd;                // T jest double.
    vector<int> vi;                   // T jest int.
    vector<double*> vpd;              // T jest double*.
    vector< vector<int> > vvi;        // T jest vector<int>, w ktrym T jest int.
}

//------------------------------------------------------------------------------

class vector_char {
    int sz;        // rozmiar
    char* elem;    // wskanik na elementy
    int space;     // size+free_space
public:
    vector_char();
    vector_char(int s);

    vector_char(const vector_char&);             // konstruktor kopiujcy
    vector_char& operator=(const vector_char &); // przypisanie kopiujce

    ~vector_char ();                             // destruktor

    char& operator[ ] (int n);                   // dostp: zwraca referencj
    const char& operator[ ] (int n) const;  

    int size() const ;                           // aktualny rozmiar
    int capacity() const;

    void resize(int newsize);                    // wzrost
    void push_back(const char& d);
    void reserve(int newalloc);
};

//------------------------------------------------------------------------------

void fct(vector<string>& v)
{
    int n = v.size();
    v.push_back("Nora");
    // ...
}

//------------------------------------------------------------------------------

template<class T> void vector<T>::push_back(const T& d) { /* ... */ };

//------------------------------------------------------------------------------
