
//
// To jest przykadowy kod z podrozdziau 11.3.2 Pliki binarne ksiki 
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include "std_lib_facilities.h"

//------------------------------------------------------------------------------

template<class T>
char* as_bytes(T& i)    // Traktuje T jako sekwencj bajtw.
{
    void* addr = &i;    // Pobiera adres pierwszego bajta
    // w pamici, w ktrej zosta zapisany obiekt.
    return static_cast<char*>(addr); // Traktuje t pami jako bajty.
}

//------------------------------------------------------------------------------

int main()
try
{
    // Otwieramy strumie istream w binarnym trybie odczytu pliku:
	cout << "Podaj nazw pliku wejciowego:\n";
    string name;
    cin >> name;
    ifstream ifs(name.c_str(),ios_base::binary);    // Uwaga: tryb strumienia
    // binary oznacza dla niego, e ma si za bardzo nie ciekawi znaczeniem bajtw.
    if (!ifs) error("Nie mona otworzy pliku wejciowego ", name);

    // Otwieramy strumie ostream w binarnym trybie do zapisu:
    cout << "Podaj nazw pliku wyjciowego:\n";
    cin >> name;
    ofstream ofs(name.c_str(),ios_base::binary);    // Uwaga: tryb strumienia
        // binary oznacza dla niego, e ma si za bardzo nie ciekawi znaczeniem bajtw.
    if (!ofs) error("Nie mona otworzy pliku wyjciowego ",name);

    vector<int> v;

    // Odczyt z pliku binarnego:
    int i;
    while (ifs.read(as_bytes(i),sizeof(int))) // Uwaga: wczytywanie bajtw.
        v.push_back(i);    

    //  operacje przy uyciu v

    // Zapisywanie do pliku binarnego:
    for(int i=0; i<v.size(); ++i)
        ofs.write(as_bytes(v[i]),sizeof(int));    // Uwaga: zapisywanie bajtw.
    return 0;
}
catch (exception& e) {
	cerr << "Bd: " << e.what() << '\n'; 
    return 1;
}
catch (...) {
    cerr << "Nieznany wyjtek.\n"; 
    return 2;
}

//------------------------------------------------------------------------------
