
//
// Przykadowy kod z rozdziau 6.3.3 "Implementowanie tokenw" ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include "std_lib_facilities.h"

//------------------------------------------------------------------------------

class Token {        // Bardzo prosty typ zdefiniowany przez uytkownika.
public:
    char kind;
    double value;
};

//------------------------------------------------------------------------------

int main()
try
{
    Token t;         // Zmienna t jest typu Token.
    t.kind = '+';    // Zmienna t reprezentuje znak +.
    Token t2;        // Zmienna t2 jest innym obiektem typu Token.
    t2.kind = '8';   // Cyfra 8 oznacza rodzaj (kind) tokenu bdcy liczb.
    t2.value = 3.14;

    Token tt = t;    // Inicjacja kopii
    if (tt.kind != t.kind) error("To niemoliwe!");
    t = t2;          // przypisanie
    cout << t.value; // wydrukuje 3.14
}
catch (exception& e) {
    cerr << "Bd: " << e.what() << '\n'; 
    return 1;
}
catch (...) {
    cerr << "Nieznany wyjtek!\n"; 
    return 2;
}

//------------------------------------------------------------------------------
