
//
// To jest przykadowy kod z podrozdziau 24.5.2 Macierze jednowymiarowe ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include "Matrix.h"

using namespace Numeric_lib;

//------------------------------------------------------------------------------

double f(double a) { return a*a; }

//------------------------------------------------------------------------------

double f2(double a, double b) { return a*b; }

//------------------------------------------------------------------------------

double scale(double d, double s) { return d*s; }

//------------------------------------------------------------------------------

void scale_in_place(double& d, double s) { d *= s; }

//------------------------------------------------------------------------------

int main()
{
    Matrix<int,1> a1(8);          // a1 jest jednowymiarow macierz liczb typu int.
    Matrix<int>   a(8);           // Oznacza Matrix<int,1> a(8);.

    a.size();                     // Liczba elementw w macierzy.
    a.dim1();                     // Liczba elementw w pierwszym wymiarze.

    int  i = 4;
    int  n = 7;
    int* p = a.data();            // Wydobywa dane jako wskanik na tablic.

    a(i);                         // i-ty element (styl jzyka Fortran), ale sprawdzany jest zakres.
    a[i];                         // i-ty element (styl jzyka C), ze sprawdzaniem zakresu.
    //a(1,2);                     // Bd: a jest macierz jednowymiarow.

    a.slice(i);                   // Elementy od elementu a[i] do koca.
    a.slice(i,n);                  // n elementw od a[i] do a[i+n1].

    a.slice(4,4) = a.slice(0,4);  // Przypisuje pierwsz poow a do jej drugiej poowy.
    a.slice(4) = a.slice(0,4);    // Przypisuje pierwsz poow a do jej drugiej poowy.

    Matrix<int> a2 = a;           // inicjowanie kopiujce
    a = a2;                       // przypisanie kopiujce
    a *= 7;                       // Skalowanie: a[i]*=7 dla kadego i (take +=, =, /=, itp.).
    a = 7;                        // a[i]=7 dla kadego i

    a.apply(f);                   // a[i]=f(a[i]) dla kadego elementu a[i]
    a.apply(f2,7);                // a[i]=f(a[i],7) dla kadego elementu a[i]

    Matrix<int> b = apply(abs,a); // Tworzy now macierz, w ktrej b(i)==abs(a(i)).

    b = a*7;                      // b[i] = a[i]*7 dla kadego i
    a *= 7;                       // a[i] =a[i]*7 dla kadego i
    Matrix<double> x(10);
    Matrix<double> y = apply(f,x);// y[i] =f(x[i]) dla kadego i
    x.apply(f);                   // x[i] =f(x[i]) dla kadego i

    b = apply(f2,a,7);            // b[i]=f(a[i],x) dla kadego i
    b = apply(scale,a,7);         // b[i] = a[i]*7 dla kadego i
    x.apply(scale_in_place,7);    // a[i] *= 7 dla kadego i

    Matrix<int> a3  = scale_and_add(a,8,a2); // Dodawanie i mnoenie w jednej operacji.
    int r = dot_product(a3,a);               // iloczyn skalarny

}

//------------------------------------------------------------------------------

void some_function(double* p, int n)
{
    double val[] = { 1.2, 2.3, 3.4, 4.5 };
    Matrix<double> data(p,n);
    Matrix<double> constants(val);
    // ...
}

//------------------------------------------------------------------------------
