
//
// To jest przykadowy kod z podrozdziau 10.10 Standardowa ptla wejciowa ksiki 
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include "std_lib_facilities.h"

//------------------------------------------------------------------------------

typedef int My_type;

//------------------------------------------------------------------------------

void input_loop_1(istream& ist)
{  
    My_type var;
    while (ist>>var) {    // Wczytuje dane do koca pliku.
        // Moe jaki test poprawnoci var.
        // Jakie operacje przy uyciu var.
    }
    // Rzadko da si odzyska sprawno po wystpieniu stanu bad. Nie naley tego prbowa, jeli nie jest to konieczne:
    if (ist.bad()) error("Nieprawidowy strumie wejciowy.");
    if (ist.fail()) {
        // Czy to by akceptowalny znak kocowy?
    }
    // Kontynuacja: znaleziono koniec pliku.
}

//------------------------------------------------------------------------------

void input_loop_2(istream& ist)
{  
    My_type var;
    while (ist>>var) {    // Wczytuje dane do koca pliku.
        // Moe jaki test poprawnoci var.
        // Jakie operacje przy uyciu var.
    }
    if (ist.fail()) { // Znak '|' peni rol symbolu koca i/lub separatora.
        ist.clear();
        char ch;
        if (!(ist>>ch && ch=='|')) error("Niepoprawny znak koca danych.");
    }
    // Kontynuacja: znaleziono koniec pliku lub znak kocowy.
}

//------------------------------------------------------------------------------

void end_of_loop(istream& ist, char term, const string& message)
{
    if (ist.fail()) { // Uycie term jako znaku koca i/lub znaku oddzielajcego.
        ist.clear();
        char ch;
        if (ist>>ch && ch==term) return;    // Wszystko jest w porzdku.
        error(message);
    }
}

//------------------------------------------------------------------------------

void input_loop_3(istream& ist)
{  
    My_type var;
    while (ist>>var) {    // Wczytuje dane do koca pliku.
        // Moe jaki test poprawnoci var.
        // Jakie operacje przy uyciu var.
    }
    end_of_loop(ist,'|',"Niepoprawne zakoczenie pliku");    // Test okrelajcy, czy mona kontynuowa.
    // Kontynuacja: znaleziono koniec pliku lub znak kocowy.
}

//------------------------------------------------------------------------------

int main()
try
{
    input_loop_3(cin);
    input_loop_2(cin);
    input_loop_1(cin);
    // Gdzie w kodzie: ist zgasza wyjtek, jeli co si nie uda:
    cin.exceptions(cin.exceptions()|ios_base::badbit);
}
catch (exception& e) {
    cerr << "Bd: " << e.what() << '\n'; 
    return 1;
}
catch (...) {
    cerr << "Nieznany wyjtek!\n"; 
    return 2;
}

//------------------------------------------------------------------------------
