
//
// To jest przykadowy kod z podrozdziau 7.5 "Reszta z dzielenia" ksiki 
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include "std_lib_facilities.h"

//------------------------------------------------------------------------------

class Token {
public:
    char kind;        // Rodzaj tokenu.
    double value;     // Dla liczb: warto.
    Token(char ch)    // Tworzy token ze znaku.
        :kind(ch), value(0) { }    
    Token(char ch, double val)     // Tworzy token ze znaku i liczby typu double.
        :kind(ch), value(val) { }
};

//------------------------------------------------------------------------------

class Token_stream {
public: 
    Token_stream();   // Tworzy strumie tokenw wczytujcy dane ze strumienia cin.
    Token get();      // Pobiera token (funkcja get() zostaa zdefiniowana w innym miejscu).
    void putback(Token t);    // Zwraca token.
private:
    bool full;        // Sprawdza czy w buforze jest token.
    Token buffer;     // Przechowuje tokeny zwrcone przez funkcj putback().
};

//------------------------------------------------------------------------------

// Konstruktor ustawia warto full w taki sposb, e oznacza pusty bufor:
Token_stream::Token_stream()
:full(false), buffer(0)    // Bufor jest pusty.
{
}

//------------------------------------------------------------------------------

// Funkcja skadowa putback() wstawia swj argument z powrotem do bufora Token_stream::
void Token_stream::putback(Token t)
{
    if (full) error("Funkcja putback() wstawia dane do penego bufora.");
    buffer = t;       // Kopiuje t do bufora.
    full = true;      // Bufor jest peny.
}

//------------------------------------------------------------------------------

Token Token_stream::get()
{
    if (full) {       // Sprawdza czy jest gotowy token.
        // Usuwa token z bufora.
        full=false;
        return buffer;
    } 

    char ch;
    cin >> ch;    // Operator >> pomija biae znaki (spacje, znaki nowego wiersza, tabulatory itp.).

    switch (ch) {
    case ';':    // Oznacza drukowanie.
    case 'q':    Oznacza koniec.
    case '(': case ')': case '+': case '-': case '*': case '/': case '%':
        return Token(ch);        // Kady znak reprezentuje sam siebie.
    case '.':
    case '0': case '1': case '2': case '3': case '4':
    case '5': case '6': case '7': case '8': case '9':
        {    
            cin.putback(ch);         // Wstawia cyfr z powrotem do strumienia wejciowego.
            double val;
            cin >> val;              // Wczytuje liczb zmiennoprzecinkow.
            return Token('8',val);   // Znak 8 reprezentuje liczb.
        }
    default:
        error("Bad token");
    }
}

//------------------------------------------------------------------------------

Token_stream ts;        // Dostarcza funkcji get() i pushback().

//------------------------------------------------------------------------------

double expression();    // Dziki tej deklaracji funkcja primary() moe wywoa funkcj expression().

//------------------------------------------------------------------------------

// Obsuga liczb i nawiasw.
double primary()
{
    Token t = ts.get();
    switch (t.kind) {
    case '(':           // Obsuga '(' wyraenie ')'.
        {
            double d = expression();
            t = ts.get();
            if (t.kind != ')') error("')' by oczekiwany");
            return d;
        }
    case '8':           // Znak 8 reprezentuje liczb.
        return t.value; // Zwraca warto liczby.
    case '-':
        return - primary();
    case '+':
        return primary();
    default:
        error("Oczekiwano czynnika.");
    }
}

//------------------------------------------------------------------------------

// Obsuga *, / oraz %.
double term()
{
    double left = primary();
    Token t = ts.get(); // Pobiera nastpny token ze strumienia tokenw.

    while(true) {
        switch (t.kind) {
        case '*':
            left *= primary();
            t = ts.get();
            break;
        case '/':
            {    
                double d = primary();
                if (d == 0) error("Dzielenie przez zero.");
                left /= d; 
                t = ts.get();
                break;
            }
        case '%':
            {
                double d = primary();
                int i1 = int(left);
                if (i1 != left) error ("Lewy argument operatora % nie jest liczb typu int.");
                int i2 = int(d);
                if (i2 != d) error ("Prawy argument operatora % nie jest liczb typu int.");
                if (i2 == 0) error("%: Dzielenie przez zero.");
                left =  i1%i2; 
                t = ts.get();
                break;
            }
        default: 
            ts.putback(t);        // Wstawia t z powrotem do strumienia tokenw.
            return left;
        }
    }
}

//------------------------------------------------------------------------------

// Obsuga + i -.
double expression()
{
    double left = term();      // Wczytuje i oblicza warto skadnika.
    Token t = ts.get();        // Pobiera nastpny token ze strumienia tokenw.

    while(true) {    
        switch(t.kind) {
        case '+':
            left += term();    // Oblicza warto skadnika i dodaje.
            t = ts.get();
            break;
        case '-':
            left -= term();    // Oblicza warto skadnika i odejmuje.
            t = ts.get();
            break;
        default: 
            ts.putback(t);     // Wstawia t z powrotem do strumienia tokenw.
            return left;       // Nie ma wicej znakw + i -. Zwraca wynik.
        }
    }
}

//------------------------------------------------------------------------------

int main()
try
{
    while (cin) {
        cout << "> ";
        Token t = ts.get();
        while (t.kind == ';') t=ts.get();    // Poera ';'
        if (t.kind == 'q') {
            keep_window_open();
            return 0;
        }
        ts.putback(t);
        cout << "= " << expression() << endl;
    }
    keep_window_open();
    return 0;
}
catch (exception& e) {
    cerr << e.what() << endl;
    keep_window_open("~~");
    return 1;
}
catch (...) {
    cerr << "Wyjtek \n";
    keep_window_open("~~");
    return 2;
}

//------------------------------------------------------------------------------
