//
// To jest przykadowy kod z podrozdziau 12.7.4 "Rysowanie wykresu funkcji" ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include "Simple_window.h"    // Dla przycisku Next.
#include "Graph.h" 
#include "std_lib_facilities.h"

using namespace Graph_lib;

//------------------------------------------------------------------------------

int main ()
try
{ 
    Point tl(100,100);    // Lewy grny rg naszego okna.

    Simple_window win(tl,600,400,"Canvas");
    // Wsprzdna ekranu tl okrelajca pooenie lewego grnego rogu okna.
    // Rozmiar okna 600*400.
    // Tytu: Kanwa.

    Axis xa(Axis::x, Point(20,300), 280, 10, "x axis"); // Tworzy o.
    // O jest rodzajem figury.
    // Axis::x oznacza o poziom.
    // Pocztek w punkcie (20,300),
    // dugo 280 pikseli,
    // 10 kresek podziaki,
    // etykieta o x.
    win.attach(xa);                      // Wie o xa z oknem win.

    Axis ya(Axis::y, Point(20,300), 280, 10, "y axis");
    ya.set_color(Color::cyan);           // Wybr koloru.
    ya.label.set_color(Color::dark_red); // Wybr koloru dla tekstu.
    win.attach(ya);

    Function sine(sin,0,100,Point(20,150),1000,50,50);    // Krzywa obrazujca sinusoid.
    // Rysuje funkcj sin() w przedziale <0,100) z punktem (0,0) w punkcie (20,150),
    // przy uyciu 1000 punktw. Skaluje wartoci x i y *50.
    win.attach(sine);

    win.set_label("Canvas #4");
    win.wait_for_button();               // Wywietl!
} 
catch(exception& e) {
    // Raport o bdzie.
    return 1;
}
catch(...) {
    // Raport o bdzie.
    return 2;
}

//------------------------------------------------------------------------------
