---------------------------------------------------
-- Sams Teach Yourself Oracle PL/SQL in Ten Minutes
-- http://forta.com/books/0672328666
-- Example table population scripts
---------------------------------------------------


---------------------------------------------
-- Utwórz tabelę klienci table
---------------------------------------------
CREATE TABLE klienci
(
  kl_id      int       NOT NULL ,
  nazwa_kl   char(50)  NOT NULL ,
  adres_kl   char(50)  NULL ,
  miasto_kl  char(50)  NULL ,
  woj_kl     char(5)   NULL ,
  kod_kl     char(10)  NULL ,
  kraj_kl    char(50)  NULL ,
  kontakt_kl char(50)  NULL ,
  email_kl   char(255) NULL 
);


---------------------------------------------
-- Utwórz tabelę pozycje
---------------------------------------------
CREATE TABLE pozycje
(
  numer_zam   int          NOT NULL ,
  pozycja_zam int          NOT NULL ,
  id_prod     char(10)     NOT NULL ,
  ilosc       int          NOT NULL ,
  cena_poz    decimal(8,2) NOT NULL
);


---------------------------------------------
-- Utwórz tabelę zamowienia
---------------------------------------------
CREATE TABLE zamowienia
(
  numer_zam  int  NOT NULL ,
  data_zam   date NOT NULL ,
  kl_id      int  NOT NULL
);

---------------------------------------------
-- Utwórz tabelę produkty
---------------------------------------------
CREATE TABLE produkty
(
  id_prod     char(10)      NOT NULL,
  id_dost     int           NOT NULL ,
  nazwa_prod  char(255)     NOT NULL ,
  cena_prod   decimal(8,2)  NOT NULL ,
  opis_prod   varchar(1000) NULL
);


---------------------------------------------
-- Utwórz tabelę dostawcy
---------------------------------------------
CREATE TABLE dostawcy
(
  id_dost     int      NOT NULL,
  nazwa_dost  char(50) NOT NULL ,
  adres_dost  char(50) NULL ,
  miasto_dost char(50) NULL ,
  woj_dost    char(5)  NULL ,
  kod_dost    char(10) NULL ,
  kraj_dost   char(50) NULL
);


---------------------------------------------
-- Utwórz tabelę prod_uwagi
---------------------------------------------
CREATE TABLE prod_uwagi
(
  id_uw    int      NOT NULL ,
  id_prod  char(10) NOT NULL ,
  data_uw  date     NOT NULL ,
  tekst_uw clob     NULL
);


----------------------
-- Definicja kluczy głównych
----------------------
ALTER TABLE klienci ADD CONSTRAINT pk_klienci PRIMARY KEY (kl_id);
ALTER TABLE pozycje ADD CONSTRAINT pk_pozycje PRIMARY KEY (numer_zam, pozycja_zam);
ALTER TABLE zamowienia ADD CONSTRAINT pk_zamowienia PRIMARY KEY (numer_zam);
ALTER TABLE produkty ADD CONSTRAINT pk_produkty PRIMARY KEY (id_prod);
ALTER TABLE dostawcy ADD CONSTRAINT pk_dostawcy PRIMARY KEY (id_dost);
ALTER TABLE prod_uwagi ADD CONSTRAINT pk_prod_uwagi PRIMARY KEY (id_uw);


---------------------------------------------
-- Definicja kluczy obcych
---------------------------------------------
ALTER TABLE pozycje ADD CONSTRAINT fk_pozycje_zamowienia FOREIGN KEY (numer_zam) REFERENCES zamowienia (numer_zam);
ALTER TABLE pozycje ADD CONSTRAINT fk_pozycje_produkty FOREIGN KEY (id_prod) REFERENCES produkty (id_prod);
ALTER TABLE zamowienia ADD CONSTRAINT fk_zamowienia_klienci FOREIGN KEY (kl_id) REFERENCES klienci (kl_id);
ALTER TABLE produkty ADD CONSTRAINT fk_produkty_dostawcy FOREIGN KEY (id_dost) REFERENCES dostawcy (id_dost);
ALTER TABLE prod_uwagi ADD CONSTRAINT fk_prod_uwagi_produkty FOREIGN KEY (id_prod) REFERENCES produkty (id_prod);
