REM $Id: webu.pkb,v 1.1 2001/11/30 23:20:19 bill Exp $
REM Z "Nauka Oracle PL/SQL" Rozdzia 4

REM Ostateczna wersja ciaa pakietu narzdzi sieciowych oglnego przeznaczenia
REM opisanego w Rozdziale 4

CREATE OR REPLACE PACKAGE BODY webu AS

   FUNCTION errfont(tekst IN VARCHAR2)
      RETURN VARCHAR2
   IS
   BEGIN
      RETURN ('<FONT color="red">' || tekst || '</FONT>');
   END;

   FUNCTION mies_lista_opcji(selected_mies IN VARCHAR2)
      RETURN VARCHAR2
   IS
      seltekst VARCHAR2(10);
      lista VARCHAR2(512) := '<OPTION value="">(Mies)' || nopu.koniec_wiersza;
      selected_miesiac_indeks PLS_INTEGER;
      mies VARCHAR2(3);
   BEGIN

      BEGIN
         selected_miesiac_indeks :=
            TO_CHAR(TO_DATE(UPPER(selected_mies), 'MON'), 'MM');
      EXCEPTION
      WHEN OTHERS THEN
         NULL;
      END;

      FOR m_num IN 1..12
      LOOP
         IF selected_miesiac_indeks = m_num
         THEN
            seltekst := ' SELECTED ';
         ELSE
            seltekst := ' ';
         END IF;
         mies := TO_CHAR(TO_DATE(m_num, 'MM'),'MON');
         lista := lista || '<OPTION' || seltekst || 'value="' || mies
            || '">' || INITCAP(mies) || nopu.koniec_wiersza;
      END LOOP;

      RETURN lista;
   END;

   FUNCTION dd_lista_opcji(selected_dd IN VARCHAR2)
      RETURN VARCHAR2
   IS
      seltekst VARCHAR2(10);
      lista VARCHAR2(768) := '<OPTION value="">(dzie)';
      selected_integer PLS_INTEGER;
   BEGIN

      BEGIN
         selected_integer := TO_NUMBER(selected_dd);
      EXCEPTION
         WHEN OTHERS
         THEN
            selected_integer := 1;
      END;

      FOR dd_num IN 1..31
      LOOP
         IF selected_integer = dd_num
         THEN
            seltekst := ' SELECTED ';
         ELSE
            seltekst := ' ';
         END IF;
         lista := lista || '<OPTION' || seltekst || 'value="' ||
            TO_CHAR(dd_num, 'FM09') || '">' || TO_CHAR(dd_num) || nopu.koniec_wiersza;
      END LOOP;

      RETURN lista;
   END;

END webu;
/

SHOW ERRORS

