REM $Id: test_dodaj_ksiazke.sql,v 1.1 2001/11/30 23:09:49 bill Exp $
REM Z "Nauka Oracle PL/SQL" strona 84

REM Wersja z anonimowym blokiem programu testujcego procedur dodaj_ksiazke
REM Uwaga: Jeli chcesz, aby numery linii zgadzay si numerami w ksice,
REM to naly usun wszystkie linie znajdujce si powyej DECLARE.

DECLARE
   l_isbn VARCHAR2(13) := '1-56592-335-9';
   l_tytul VARCHAR2(200) := 'Programowanie w Oracle PL/SQL';
   l_opis VARCHAR2(2000) := 'Podrcznik encyklopeduczny dla programistw ' ||
       'PL/SQL wraz z przykadami i wskazwkami na temat programowania.';
   l_autor varchar2(200) := 'Feuerstein, Steven, Bill Pribyl';
   l_data_wydania DATE := TO_DATE('01-WRZ-1997', 'DD-MON-YYYY');
   l_liczba_stron NUMBER := 987;
   l_id_kodu_kresk VARCHAR2(100) := '100000001';

   CURSOR liczbaKsiazekCur IS
      SELECT COUNT(*) FROM ksiazki;

   CURSOR liczbaEgzemplarzyCur IS
      SELECT COUNT(*) FROM egzemplarze_ksiazki;

   CURSOR pasujaceKsiazkiCur IS
      SELECT COUNT(*) FROM ksiazki
       WHERE isbn = l_isbn AND tytul = l_tytul AND opis = l_opis
         AND autor = l_autor AND data_wydania = l_data_wydania
         AND liczba_stron = l_liczba_stron;

   CURSOR pasujaceEgzemplarzeCur IS
      SELECT COUNT(*) FROM egzemplarze_ksiazki
       WHERE isbn = l_isbn AND id_kodu_kresk = l_id_kodu_kresk;

   ile NUMBER;
   l_sqlcode NUMBER;
BEGIN
   DELETE egzemplarze_ksiazki;
   DELETE ksiazki;

   dodaj_ksiazke(isbn_in => l_isbn, id_kodu_kresk_in => l_id_kodu_kresk, 
      tytul_in => l_tytul, opis_in => l_opis, autor_in => l_autor,
      data_wydania_in => l_data_wydania, liczba_stron_in => l_liczba_stron);

   OPEN pasujaceKsiazkiCur;
   FETCH pasujaceKsiazkiCur INTO ile;
   testrownosci_bool('procedura dodaj, pobrane dane o ksice odpowiadaj wstawionym', 
      wartosc_oczekiwana => TRUE, wartosc_otrzymana => pasujaceKsiazkiCur%FOUND);
   CLOSE pasujaceKsiazkiCur;

   BEGIN
      dodaj_ksiazke(isbn_in => NULL, id_kodu_kresk_in => 'foo', tytul_in => 'foo',
         opis_in => 'foo', autor_in => 'foo',
         data_wydania_in => SYSDATE, liczba_stron_in => 0);
      l_sqlcode := SQLCODE;
   EXCEPTION
   WHEN OTHERS THEN
      l_sqlcode := SQLCODE;
   END;

   testrownosci('procedura dodaj, detekcja wartoci NULL na wejciu',
      wartosc_oczekiwana => '-6502', wartosc_otrzymana => TO_CHAR(l_sqlcode));

   OPEN liczbaKsiazekCur;
   FETCH liczbaKsiazekCur INTO ile;
   testrownosci('procedura dodaj, liczba rekordw ksiazek', wartosc_oczekiwana => '1',
      wartosc_otrzymana => ile);
   CLOSE liczbaKsiazekCur;

   OPEN liczbaEgzemplarzyCur;
   FETCH liczbaEgzemplarzyCur INTO ile;
   testrownosci('procedura dodaj, liczba rekordw egzemplarzy', wartosc_oczekiwana => '1',
      wartosc_otrzymana => ile);
   CLOSE liczbaEgzemplarzyCur;

   OPEN pasujaceEgzemplarzeCur;
   FETCH pasujaceEgzemplarzeCur INTO ile;
   testrownosci_bool('procedura dodaj, pobrane dane o egzemplarzu odpowiadaj wstawionym', 
      wartosc_oczekiwana => TRUE, wartosc_otrzymana => pasujaceEgzemplarzeCur%FOUND);
   CLOSE pasujaceEgzemplarzeCur;

   BEGIN
      dodaj_ksiazke(isbn_in => l_isbn, id_kodu_kresk_in => l_id_kodu_kresk, 
         tytul_in => l_tytul, opis_in => l_opis, autor_in => l_autor,
         data_wydania_in => l_data_wydania,
         liczba_stron_in => l_liczba_stron);
      l_sqlcode := SQLCODE;
   EXCEPTION
      WHEN OTHERS THEN
         l_sqlcode := SQLCODE;
   END;
   testrownosci('procedura dodaj, detekcja duplikatw isbn',
      wartosc_oczekiwana => '-1', wartosc_otrzymana => l_sqlcode);
END;
/

