REM $Id: create_user.sql,v 1.1 2001/11/30 23:41:39 bill Exp $
REM Z "Nauka Oracle PL/SQL"

REM Tworzy uytkownika bdcego wacicielem obiekty NOP. Nie trzeba wykonywa tego
REM skryptu; zamiast tego, mona po prostu utworzy te obiekty we wasnym schemacie.

DISCONNECT
ACCEPT haslo_system CHAR PROMPT 'Podaj haso dla konta SYSTEM: ' HIDE
ACCEPT nowy_uzytkownik CHAR PROMPT 'Podaj nazw konta nowego uytkownika Oracle: '
ACCEPT nowe_haslo CHAR PROMPT 'Podaj haso nowego uytkownika Oracle: ' HIDE
ACCEPT default_tablespace -
   CHAR PROMPT 'Nazwa domylnej przestrzeni tabel (domylnie USERS): ' DEFAULT USERS
ACCEPT temporary_tablespace -
   CHAR PROMPT 'Nazwa tymczasowej przestrzeni tabel (domylnie TEMP): ' DEFAULT TEMP

CONNECT SYSTEM/&&haslo_system
@@login

PROMPT Tworzenie uytkownika...
CREATE USER &&nowy_uzytkownik IDENTIFIED BY &&nowe_haslo;

PROMPT Przypisywanie domylnej przestrzeni tabel uytkownika...
ALTER USER &&nowy_uzytkownik
   DEFAULT TABLESPACE &&default_tablespace;

PROMPT Przypisywanie tymczasowej przestrzeni tabel uytkownika...
ALTER USER &&nowy_uzytkownik
   TEMPORARY TABLESPACE &&temporary_tablespace;

PROMPT Przyznawanie uytkownikowi nieograniczonej quota na domyln przestrze tabel...
ALTER USER &&nowy_uzytkownik
   QUOTA UNLIMITED ON &&default_tablespace;

PROMPT Przyznawanie rnych uprawnie uytkownikowi...
GRANT CREATE SESSION,
   CREATE TABLE,
   CREATE TYPE,
   CREATE PROCEDURE,
   CREATE TRIGGER,
   CREATE SEQUENCE,
   CREATE LIBRARY
TO &&nowy_uzytkownik;

DISCONNECT

