REM $Id: ksiazka.pks,v 1.1 2001/11/30 23:24:55 bill Exp $
REM Z "Nauka Oracle PL/SQL" strona 350

REM Specyfikacja wersji pakietu ksiazka z Rozdziau 9, w ktrej dodano funkcje
REM zabezpieczajce

CREATE OR REPLACE PACKAGE ksiazka
AS

   TYPE refcur_t IS REF CURSOR;

   PROCEDURE dodaj(isbn_in IN VARCHAR2, tytul_in IN VARCHAR2,
      autor_in IN VARCHAR2, liczba_stron_in IN NUMBER, 
      opis_in IN VARCHAR2 DEFAULT NULL,
      data_wydania_in IN DATE DEFAULT NULL,
      id_kodu_kresk_in IN VARCHAR2 DEFAULT NULL,
      id_wykonawcy uzytk_bibl.id%TYPE);

   PROCEDURE dodaj_egzemplarz(isbn_in IN VARCHAR2, id_kodu_kresk_in IN VARCHAR2,
      id_wykonawcy uzytk_bibl.id%TYPE);

   FUNCTION ilosc_egzemp_ksiazki(isbn_in IN VARCHAR2)
   RETURN NUMBER;

   PROCEDURE zmien(isbn_in IN VARCHAR2, nowy_tytul IN VARCHAR2, 
      nowy_autor IN VARCHAR2, nowa_liczba_stron IN NUMBER,
      nowy_opis IN VARCHAR2 DEFAULT NULL, 
      nowa_data_wydania IN DATE DEFAULT NULL,
      id_wykonawcy uzytk_bibl.id%TYPE);

   PROCEDURE usun_egzemplarz(isbn_in IN VARCHAR2, id_kodu_kresk_in IN VARCHAR2,
      id_wykonawcy uzytk_bibl.id%TYPE);

   PROCEDURE usun(isbn_in IN VARCHAR2,
      id_wykonawcy uzytk_bibl.id%TYPE);

   FUNCTION ksiazka_cur (isbn_in IN VARCHAR2,
      tytul_in IN VARCHAR2,
      autor_in IN VARCHAR2,
      data_wydania_in IN VARCHAR2,
      startrec IN VARCHAR2 DEFAULT '1',
      wierszy_do_pobrania IN VARCHAR2 DEFAULT 'ALL',
      orderby IN VARCHAR2 DEFAULT '1')
   RETURN refcur_t;

   FUNCTION egzemp_ksiazki_cur (isbn_in VARCHAR2)
   RETURN refcur_t;

END ksiazka;

/

SHOW ERRORS

