REM $Id$
REM Z "Nauka Oracle PL/SQL" strona 281

REM Tworzy procedur adujc ca zawarto pliku do tabeli zawartosc_pliku

CREATE OR REPLACE PROCEDURE laduj_plik_do_tabeli (nazwa_kat_in IN VARCHAR2,
   nazwa_pliku_in IN VARCHAR2, liczba_zn_eol IN PLS_INTEGER DEFAULT 1)
IS
   fh UTL_FILE.FILE_TYPE;
   bufor VARCHAR2(4000);
   lnr PLS_INTEGER := 0;
   max_varchar_c CONSTANT PLS_INTEGER := 4000;
   eof BOOLEAN := FALSE;
BEGIN
   nopu.okresl_nie_null(nazwa_kat_in);
   nopu.okresl_nie_null(nazwa_pliku_in);
   nopu.okresl(liczba_zn_eol BETWEEN 0 AND 3,
     'liczba_zn_eol nie jest w przedziale od 0 do 3');

   fh := UTL_FILE.FOPEN(location => nazwa_kat_in, 
                        filename => nazwa_pliku_in, 
                        open_mode => 'r',
                        max_linesize => max_varchar_c + liczba_zn_eol);

   DELETE zawartosc_pliku
    WHERE nazwa_kat = nazwa_kat_in
      AND nazwa_pliku = nazwa_pliku_in;

   WHILE NOT eof
   LOOP
      pobierz_nast_linie(fh, bufor, eof);
      lnr := lnr + 1;
      INSERT INTO zawartosc_pliku (nazwa_kat, nazwa_pliku, nr_linii, tekst)
      VALUES (nazwa_kat_in, nazwa_pliku_in, lnr, bufor);
   END LOOP;

   UTL_FILE.FCLOSE(fh);

EXCEPTION
   WHEN OTHERS
   THEN
      IF UTL_FILE.IS_OPEN(fh)
      THEN
         UTL_FILE.FCLOSE(fh);
      END IF;
      RAISE;

END laduj_plik_do_tabeli;
/

SHOW ERRORS

