REM $Id: genpobierz.pro,v 1.1 2001/11/30 23:10:54 bill Exp $
REM Z "Nauka Oracle PL/SQL" strona 213

REM Procedura ilustrujca dizaanie prostego generatora kodu

REM Uwaga: W systemie Oracle9i, DBMS_OUTPUT.PUT_LINE wci ignoruje wiodce
REM znaki spacji. To znaczy, e zamiast '     xyz' wydrukuje 'xyz'. Tak wic
REM formatowanie generowanego tekstu znajdujce sie poniej odnosi si tylko
REM do "tego" pliku, nie za generowanego.

CREATE OR REPLACE PROCEDURE genpobierz (
   tab_in IN VARCHAR2,
   kol_in IN VARCHAR2,
   pkey_in IN VARCHAR2
)
IS
   v_tabkol VARCHAR2 (100) := LOWER (tab_in || '.' || kol_in);
   v_tabpkey VARCHAR2 (100) := LOWER (tab_in || '.' || pkey_in);
   v_pkeyin VARCHAR2 (100) := LOWER (pkey_in || '_in');
BEGIN
   DBMS_OUTPUT.PUT_LINE ('CREATE OR REPLACE FUNCTION jeden_' || kol_in || ' (');
   DBMS_OUTPUT.PUT_LINE (
      '   ' || v_pkeyin || ' IN ' || v_tabpkey || '%TYPE)');
   DBMS_OUTPUT.PUT_LINE ('   RETURN ' || v_tabkol || '%TYPE');
   DBMS_OUTPUT.PUT_LINE ('IS');
   DBMS_OUTPUT.PUT_LINE ('   zwracane ' || v_tabkol || '%TYPE;');
   DBMS_OUTPUT.PUT_LINE ('BEGIN');
   DBMS_OUTPUT.PUT_LINE ('   SELECT ' || kol_in);
   DBMS_OUTPUT.PUT_LINE ('     INTO zwracane');
   DBMS_OUTPUT.PUT_LINE ('     FROM ' || tab_in);
   DBMS_OUTPUT.PUT_LINE ('    WHERE ' || pkey_in || ' = ' || v_pkeyin || ';');
   DBMS_OUTPUT.PUT_LINE ('   RETURN zwracane;');
   DBMS_OUTPUT.PUT_LINE ('EXCEPTION');
   DBMS_OUTPUT.PUT_LINE ('   WHEN NO_DATA_FOUND');
   DBMS_OUTPUT.PUT_LINE ('   THEN');
   DBMS_OUTPUT.PUT_LINE ('      RETURN NULL;');
   DBMS_OUTPUT.PUT_LINE ('END;');
   DBMS_OUTPUT.PUT_LINE ('/');
END;
/

SHOW ERRORS

