REM $Id: rowtype.sql,v 1.1 2001/11/30 23:19:51 bill Exp $
REM Z "Nauka Oracle PL/SQL" strona 163

REM Ilustruje pobranie danych do zmiennej rekordowej zadeklarowanej
REM z uyciem %ROWTYPE

DECLARE
   CURSOR kcur
       IS SELECT tytul, data_wydania
     FROM ksiazki
    WHERE UPPER(autor) LIKE 'SHAKESPEARE%';

   krec kcur%ROWTYPE;

BEGIN
   OPEN kcur;
   LOOP
      FETCH kcur INTO krec;
      EXIT WHEN kcur%NOTFOUND;
      DBMS_OUTPUT.PUT_LINE(kcur%ROWCOUNT
         || ') ' || krec.tytul
         || ', opublikowana w '
         || TO_CHAR(krec.data_wydania, 'YYYY'));
   END LOOP;
   CLOSE kcur;
END;
/

