REM $Id: nopu.pks,v 1.1 2001/11/30 23:20:19 bill Exp $
REM Z "Nauka Oracle PL/SQL" Rozdzia 4

REM Specyfikacja pakietu zawierajcego najbardziej oglne narzdzia uywane
REM w ksice.  "nopu" = Nauka Oracle PL/SQL Utilities.

CREATE OR REPLACE PACKAGE nopu
AS

   koniec_wiersza CONSTANT VARCHAR2(1) := CHR(10);

   SUBTYPE sqlboolean IS VARCHAR2(1);
   sqltrue CONSTANT sqlboolean := 'T';
   sqlfalse CONSTANT sqlboolean := 'F';

   PROCEDURE ustaw_dflt_date_format(format_daty IN VARCHAR2);

   FUNCTION dflt_date_format
      RETURN VARCHAR2;

   FUNCTION czy_lancuch (cos IN VARCHAR2)
      RETURN BOOLEAN;

   FUNCTION czy_number (cos IN VARCHAR2)
      RETURN BOOLEAN;

   FUNCTION czy_data (cos IN VARCHAR2,
      format_daty IN VARCHAR2 DEFAULT dflt_date_format)
      RETURN BOOLEAN;

   FUNCTION lanc_pasuje (cos IN VARCHAR2,
      min_dlugosc IN NUMBER,
      max_dlugosc IN NUMBER)
      RETURN BOOLEAN;

END nopu;
/

SHOW ERRORS

