reM $Id: insert_jedna.sql,v 1.1 2001/11/30 23:09:49 bill Exp $
REM Z "Nauka Oracle PL/SQL" strona 64

REM Ilustruje bezporednie uycie instrukcji INSERT, wraz z dodatkow
REM dyskusj na temat koca linii w acuchach znakw

COLUMN AUTOR FORMAT A70

REM Usuwamy ksik w celu zapobieenia bdom spowodowanym prbami wstawienia
REM duplikatu. Ustawiamy FEEDBACK OFF w celu uniknicia mylcych komunikatw
REM o bdach jeli ksiki nie ma.
SET FEEDBACK OFF
DELETE ksiazki WHERE isbn = '0-596-00180-0';
SET FEEDBACK 5
SET ECHO ON

/* Uwaga: W pierwszym wydaniu tej ksiki uyto nastpujcego zapisu
 instrukcji INSERT:
*/

INSERT INTO ksiazki (isbn, tytul, autor)
VALUES ('0-596-00180-0', 'Nauka Oracle PL/SQL', 'Bill Pribyl, 
Steven Feuerstein');

/* Warto zwrci uwag na znak koca linii midzy "," a "Steven". W SQL*Plus
mona rozdziela w ten sposb acuchy znakw midzy wierszami, ale spjrzmy, co
zostaje zachowane w kolumnie autor.
*/

SELECT autor FROM ksiazki WHERE isbn = '0-596-00180-0';

/* Znak koca linii take jest zachowywany w bazie danych. A nie o to chodzio.
W celu poprawienia, naley usun najpierw wstawiony wanie rekord przy uyciu
instrukcji DELETE:
*/

DELETE ksiazki WHERE isbn = '0-596-00180-0';

/* ...oraz wykona polecenie raz jeszcze w sposb nastpujcy: */

INSERT INTO ksiazki (isbn, tytul, autor)
VALUES ('0-596-00180-0', 'Nauka Oracle PL/SQL',
   'Bill Pribyl, Steven Feuerstein');

/* Sprawdmy teraz dane: */

SELECT autor FROM ksiazki WHERE isbn = '0-596-00180-0';

/* Teraz lepiej! */

SET ECHO OFF
