<?php
class previewReportBCO{
    function __construct($data){
        $this->data = $data;
    }
    function execute(){
       if(!$_REQUEST['patient'] || !$_REQUEST['stats'] || !$_REQUEST['from'] || !$_REQUEST['to']){
            return null;
        }
        $aPatientID = $_REQUEST['patient'];
        $aStatisticsList = addslashes($_REQUEST['stats']);
        $aFromDate = $_REQUEST['from'];
        $aToDate = $_REQUEST['to'];
        //przygotowanie tablicy połączeń
        $fieldArray = array(array(":aPatientID", $aPatientID, SQLT_CHR),
                        array(":aFromDate", $aFromDate, SQLT_CHR),
                        array(":aToDate", $aToDate, SQLT_CHR));
        //początek zapytania
        $aSQLString = "SELECT ";
        //pobranie tablicy z informacjami
        $aStatsArray = explode( ";", $aStatisticsList);
        $numStats = sizeof($aStatsArray);
        //wstawienie wyrażenia łączącego zmienne dla każdej informacji
        for($i = 0; $i < $numStats; $i++){
            $aStat = $aStatsArray[$i];
            //jeśli nazwa informacji kończy się ciągiem _DATE zmień formatowanie
            //wyniku zapytania
            if(substr($aStat, strlen($aStat) - strlen("_DATE")) == "_DATE"){
                $aStat = "to_char(".$aStat.",'DD-MM-YYYY') as ".$aStat;
            }
            $aSQLString .= $aStat;
            if($i < $numStats - 1){
                $aSQLString .=",";
            }
        }
        //dokończ zapytanie
        $aSQLString .= " FROM visit WHERE patient_id = :aPatientID AND visit_date BETWEEN to_date(:aFromDate,'dd mm yyyy') AND to_date(:aToDate,'dd mm yyyy')";
        $aSQLString .= " ORDER BY VISIT_DATE";
        error_log($aSQLString);
        require_once getcwd().DIRECTORY_SEPARATOR.'DBModel.inc';//dołącz plik z obsługą bazy danych
        $model = new DBModel();
        //pobierz dane do podglądu raportu
        return $model->getData($aSQLString, $fieldArray);
    }
}
