/*
*   Jest to narzędzie do śledzenia historii działające w przeglądarkach Firefox, Safari i IE
*
*   W safari skorzystanie z wskaźnika # i ukrytej ramki iframe powoduje przeładowanie całej strony przy
*   każdym skorzystaniu z przycisków przechodzenia do przodu i cofania. Choć nie jest to wydajne - działa.
*   Safari korzysta z wątków do uaktualniania URLa dlatego dołączone jest opóźnienie umożliwiające poczekanie
*   aż zostanie ono wykonane.
*
*   IE wymaga by ukryta ramka iframe była dodana w źródle głównej strony przy generowaniu elementów historii
*   dla przycisków umożliwiających cofanie i przechodzenie do przodu. 
*   Przeglądarka IE 6 będzie przechodziła do strony głównej jeśli użytkownik opuści serwis.
*
*   Firefox w Windows będzie generował elementy historii przy każdej zmianie URLa oraz przy każdej zmianie 
*   źródła ukrytej ramki iframe. Z tego powodu w Firefoksie nie są dokonywane zmiany iframe. 
*   Takie dublowanie działania nie zachodzi w Firefoksie pod OS X.
*/

//milisekundy pomiędzy sprawdzeniami uaktualnienia strony
var pageUpdateDelayMillis = 100;
//URL głównej strony
var baseURL = window.location.href.split('#')[0];

/* metoda wywoływana przy ładowaniu głównej strony */
function loadFirstSubPage(aCmd){
	//pobierz aktualne polecenie jeśli się pojawiło
    aCmd = getSubPageCommand() || aCmd;
    //jeśli polecenie zostało przekazane uaktualnij URL odpowiednim identyfikatorem
    if(aCmd){
        updateURL(aCmd, null);
    }
    //ponieważ uaktualnienie URLa w Safari wykonywane jest przez inny wątek, 
    //przed wywołaniem updateSubPage dodane jest opóźnienie
	if(navigator.userAgent.indexOf('AppleWebKit') >= 0){
        //opóźnienie 100 milisekund przed pobraniem i wyświetleniem podstrony
		setTimeout(updateSubPage, 100);
	}
	else{
        //pobierz i wyświetl odpowiednią podstronę
		updateSubPage();
	}
    //pętla sprawdzająca czy potrzebne jest załadowanie i wyświetlenie podstrony
	setInterval(checkURLForUpdate, pageUpdateDelayMillis);
}
/*  
*   funkcja wykorzystywana w setInterval by sprawdzić w URL czy trzeba zmienić podstronę
*/
function checkURLForUpdate(){
    //nie rób nic jeśli strona lub URL są w tym momencie uaktualniane
	if(!session.hasAttribute('updatingPage') && !session.hasAttribute('updatingURL')){
        //pobierz aktualną deklarację odnośnika z URLa
        var aCmd = getSubPageCommand();
        //jeśli atrybut sesji urlCmd nie jest taki sam jak nowy, uaktualnij stronę
		if(session.getAttribute('urlCmd') != null && session.getAttribute('urlCmd') != aCmd){
			updateSubPage();
		}
	}
}

/* 
*  zmień wyświetlaną podstronę
*/
function updateSubPage(){
	var pageCmd = getSubPageCommand();
	//dodaj atrybut by uniemożliwić wywoływanie tej funkcji przy automatycznym sprawdzaniu 
	session.addAttribute('updatingPage', 'true');
    //dodaj aktualne polecenie do sesji
	session.addAttribute('urlCmd', pageCmd);
    //zażądaj by dispatcher załadował stronę
	theController.dispatch(pageCmd);
	//jeśli iframe jest używane w Firefox pod Windows każda podstrona pojawiłaby się dwukrotnie więc nie korzystaj z tego
    if(navigator.userAgent.indexOf('Firefox') < 0){
		useHistoryIframe(pageCmd);
	}
    //odblokuj używanie tej funkcji przy automatycznym sprawdzaniu 
	session.removeAttribute('updatingPage');
}

/*
*  Sprawdzenie wskaźnika w URL
*/
function updateURL(aCmd, event){
    //zablokuj możliwość dwukrotnego wywołania tej funkcji w tym samym momencie
	session.addAttribute('updatingURL', 'true');
	if(aCmd != null){
      //pobierz aktualne polecenie z URLa
      var currentCommand = getSubPageCommand();
      //zastąp istniejące polecenie nowym jeśli się różnią
      if(currentCommand != aCmd){
		window.location.href = baseURL+'#'+aCmd;
	  }
      //upewnij się że zdarzenie od myszki zostało pobrane
      event = event || window.event;
      //zatrzymaj standardową obsługę zdarzenia od myszki
      stopStandardBehavior(event);
    }
    //odblokuj wywoływanie tej funkcji
	session.removeAttribute('updatingURL');
}
/*
*  pobierz cmd z URL
*/
function getSubPageCommand(){
    //pobierz polecenie z URL
	var urlArray = window.location.href.split('#');
    //ustaw domyślną wartość jeśli polecenie nie zostanie odnalezione
	var pageCmd = 'home';
	if(urlArray.length > 1){
		pageCmd = urlArray[1];
	}
	return pageCmd;
}
 /*
 * zatrzymaj standardową obsługę zdarzenia
 */
function stopStandardBehavior(event){
    if(event){
        if (event.preventDefault)
                event.preventDefault();
        event.returnValue = false;
    }
}
/* 
*  uaktualnia ramkę iframe tak by zawierała aktualne polecenie do pobrania przez Safari i IE
*/
function useHistoryIframe(aCmd){
	var histIframe = document.getElementById('history_frame');
	histIframe.src = 'tracking.html?'+aCmd;
}
