/*
* Oznaczenie stanu żądania - niezainicjalizowane - '0'.
 */
ServerAO.UNITITIALIZED = 0;

/*
 * Oznaczenie stanu żądania - stworzone, ale nie wysłane - '1'.
 */
ServerAO.SETUP = 1;

/*
 * Oznaczenie stanu żądania - wysłane, ale nie potwierdzone - '2'.
 */
ServerAO.SENT = 2;

/*
 * Oznaczenie stanu żądania - w trakcie wykonywania - '3'.
 */
ServerAO.IN_PROCESS = 3;

/*
 * Oznaczenie stanu żądania - zakończone - '4'.
 */
ServerAO.COMPLETE = 4;


/*
 * Oznaczenie kodu statusu HTTP przy pobieraniu plików w Firefox - '0'. Inne kody statusu HTTP można znaleźć w www.w3.org/Protocols/rfc2616/rfc2616-sec10.html.
 */
ServerAO.FireFox_HTTP_File_Access = 0;

/*
 * Oznaczenie kodu statusu HTTP przy pobieraniu plików w Firefox - 'nieokreślony'. Inne kody statusu HTTP można znaleźć w www.w3.org/Protocols/rfc2616/rfc2616-sec10.html. 
 */
ServerAO.OSX_HTTP_File_Access = null;

/*
 * Oznaczenie kodu statusu HTTP OK - '200'. Inne kody statusu HTTP można znaleźć w www.w3.org/Protocols/rfc2616/rfc2616-sec10.html. 
 */
ServerAO.HTTP_OK = 200;

/*
 * Oznaczenie kodu statusu HTTP Bad Request (niepoprawne żądanie) - '400'. Inne kody statusu HTTP można znaleźć w www.w3.org/Protocols/rfc2616/rfc2616-sec10.html. 
 */
ServerAO.HTTP_BADREQUEST = 400;

/*
 * Oznaczenie kodu statusu HTTP Version Not Supported (nieobsługiwana wersja) - '505'. Inne kody statusu HTTP można znaleźć w www.w3.org/Protocols/rfc2616/rfc2616-sec10.html. 
 */
ServerAO.HTTP_VERSION_NOT_SUPPORTED = 505;



/*
*Konstruktor nowego obiektu ServerAO. Server Access Object służy do tworzenia wszystkich 
*  żądań danych z serwera oraz żądań przesłania danych do serwera oraz zajmuje się 
*  przygotowaniem wszytkiego co potrzebne do poprawnego wykonania takich wywołań. 
*  Wszystkie wykonywane wywołania są asynchroniczne. 
*  parametr 1: URL - URL głównego punktu dostępowego aplikacji
*/
function ServerAO(URL){
      this.URL = URL;

      /*
      * Wykonuje wszystkie wywołania serwera służące do pobierania lub wysyłania danych. W tej metodzie tworzony jest i wykorzystywany obiekt tXMLHttpRequest. 
      * parametr 1: {String} callType - GET, POST, lub inny typ HTTP 
      * parametr 2: {Object} whenDone - VCO do wywołania po otrzymaniu danych z serwera
      * parametr 3: {String} dataType - zawartość może być w postaci dowolnego tekstu lub XMLa 
      * parametr 4: {boolean} refresh - oznaczenie czy potrzebne jest odświeżenie w sytuacji jeśli dane są już w cache
      * parametr 5: {String} parameterSequence - lista parametrów dodawanych do URL
      * parametr 6: {String or DOM element} data - dane do przesłania w żądaniu typu POST
      * parametr 7: {Object} HTTPHeaders - mapa nagłówków i ich wartości 
      */
      this.makeCall = function(callType, whenDone, dataType, refresh, parameterSequence, data, HTTPHeaders){
            if(dataType == null){
                  dataType = 'Text';//domyślna wartość
            }
            if(refresh == null){
                  refresh = false;//domyślna wartość
            }
            //utwórz obiekt żądania w dowolnej przeglądarce
            if (!window.XMLHttpRequest) {
            /*
            *     w przeglądarce IE6 i starszych metoda XMLHttpRequest nie jest 
            *     zdefiniowana. Po zdefiniowaniu jej za pierwszym razem może być
            *     później ponownie wykorzystywana bez ponownego definiowania.
            */
               window.XMLHttpRequest = function() {
                     return new ActiveXObject("Microsoft.XMLHTTP");
               };
            } 
            var http = null;
            try {
                  http = new XMLHttpRequest();
            } 
            catch(e) {
                  return;
            }
            var isAsynch = true;//zawsze wywołania asynchroniczne
            //tworzy połączenie z serwerem pod adresem 'this.URL'.
            http.open(callType,this.URL+'?'+parameterSequence, isAsynch);
            if(refresh){
            // aby wyłączyć cache i wymusić wywoływanie serwera nalezy ustawić nagłówek
            // 'If-Modified-Since' na datę w przeszłości
              http.setRequestHeader( "If-Modified-Since", "Sat, 1 Jan 2000 0:00:00 GMT" );
            }
            //jeśli są nagłówki dodaj je do żądania
            if(this.HTTPHeaders != null){
                  for(var key in HTTPHeaders){
			http.setRequestHeader(key, HTTPHeaders[key]);
                  }
            }
        //jeśli wykonywane jest żądanie POST i mają być wysłane dane, usttttaw nagłówek
	//opisujący typ zawartości aby dane były poprawnie zakodowane i odkodowane po stronie serwera
            if(callType =="POST" && data !=null){
            	http.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
            }

            /*
            *     Ustal którą funkcję wywoływać gdy serwer prześle dane do klienta. 
            *     Dla ServerAO jest to funkcja inline zdefiniowana poniżej.
            *     Powodem wykorzystania funkcji inline jest to że mogą być wykorzystane zmienne z metody makeCall.
            *     Jeśli nie będzie wykorzystana funkcja inline, ustawia się tylko nazwę funkcji do wywołania 
            *     jako metody klasy HTTP.
            */
            http.onreadystatechange = function(){
		/*
                 *     Obsługuj tylko kompletne komunikaty z serwera
                 */
                if(http.readyState == ServerAO.COMPLETE){
             	/*
                 *  Pobieraj dane jeśli serwer zwraca informację że przetwarzanie żądania
                 *  się powiodło lub jeśli żądanie dotyczyło pliku zapisanego na serwerze.
                 */
                var resultData = null;//null oznacza błąd przetwarzania
		var errorHeader = http.getResponseHeader('Custom-Error-Header');
                //Firefox ustawia errorHeader na null
                //IE7 przypisuje mu pusty ciąg znaków 
                if(errorHeader != null && errorHeader.length > 0){
                    //whenDone nie może zostać zmodyfikowane dlatego szybko kończy działanie
                    new ErrorHandlerVCO().notify(errorHeader);
                    http = null;
                    return;
                }						
                else if(http.status == ServerAO.HTTP_OK || http.status == ServerAO.FireFox_HTTP_File_Access
                     || http.status == ServerAO.OSX_HTTP_File_Access){
                     
                    resultData = http['response'+dataType];//pobierz dane tekstowe lub XML
                }
                if(whenDone != null){
                     //wywołaj metodę notify obiektu whenDone 
                     whenDone.notify(resultData);
                }
                http = null;//wymuś zwolnienie pamięci zajętej przez obiekt żądania
               }
	      };
            /*
            *     Wyślij utworzone żądanie i dołącz dane do żądania 'POST'.
            */
            http.send(this.data);
      }
}
