var theSAO = new ServerAO('main.php');//punkt dostępu po stronie serwera obsługujący całą komunikację
/*
*  W zależności od polecenie wysłanego przez serwer 
*  pewne rodzaje błędów powodują wywołanie odpowiednich
*  VCO obsługujących te błędy.
*/
function ErrorHandlerVCO(){
	this.acceptableErrorCommands = {showErrorMessage:'showErrorDialog', badLogin:'showBadLogin', storeReportFailure:'showStoreReportFailure', noAllowedReport:'showReportError'};
    
    this.notify = function(data){
        //oddziel polecenie od innych komunikatów nietypowym ciągiem znaków (_DeLiMiTeRsTrInG_)
        var dataArray = data.split("_DeLiMiTeRsTrInG_");
        //pobierz polecenie
		var commandName = dataArray[0];
        var vcoName = null;
        //jeśli polecenie jest wymienione na liście poprawnych poleceń
        //wygeneruj nazwę VCO do utworzenia
        if(commandName != null){
            vcoName = this.acceptableErrorCommands[commandName]+"VCO";
        }
        if(vcoName != null){
            //utwórz VCO obsługujące błąd
            var aVCO = new window[vcoName]();
            //uruchom kod obsługujący błąd w VCO
            aVCO.notify(dataArray[1]);
        }
	}
    
}
/*
* Wyświetlenie okna z dynamicznie zmienianym komunikatem
*/
function showErrorDialogVCO(){
    this.notify = function(data){
        alert(data);
    }
}
/*
* Ekran wyświetlający informację o błędzie logowania zarówno w 
* przypadku niepoprawnych danych jak i brakujących parametrów
*/
function showBadLoginVCO(){
    this.notify = function(){
        session.addAttribute('badLogin', true);
        updateURL("badLogin", null);
    }
}
/*
 *
 */
function showStoreReportFailureVCO(){
    this.notify = function(){
        document.getElementById('reportWarningDiv').innerHTML = 'Zapisanie raportu w tej chwili nie jest możliwe. Proszę spróbować później.';
    }
}
function showReportErrorVCO(){
    this.notify = function(){
        updateURL("vw_all_rep", null);
    }
}
function showLoginVCO(){
    this.notify = function(data){
        if(data != 'login'){
            //sposób na odnalezienie widocznych pól wprowadzania danych w Safari
            var loginDisplayContent = document.getElementById('loginHolder').innerHTML;
            //usuń wszystkie wystąpienia 'Stored'
            //loginDisplayContent = loginDisplayContent.replace("Stored",'','g');
            loginDisplayContent = loginDisplayContent.replace(/Stored/g,'');
            //wyświetl ekran logowania
            document.getElementById('content').innerHTML = loginDisplayContent;
            if(session.getAttribute('badLogin')){
                var loginErrorMsg = document.getElementById('loginErrorDisplay');
                loginErrorMsg.style.display = 'block';
            }
        }
    }
}

/*
*  Informacje o pacjentach
*/
function getPatientsBCO(){//pobiera dane
    //Dane i nagłówki nie są podane jako parametry. Będą miały wartość null.
	theSAO.makeCall('GET', new getPatientsVCO(), 'Text', true, 'cmd=pat');
}
function getPatientsVCO(){//uaktualnia stronę po odebraniu danych
	this.notify = function(data){
		document.getElementById('content').innerHTML = data;
	}
}
/*
*  Informacje o pielęgniarzach
*/
function getNursesBCO(){
	theSAO.makeCall('GET', new getNursesVCO(), 'Text', true, 'cmd=nur');
}
function getNursesVCO(){//uaktualnia stronę po odebraniu danych
	this.notify = function(data){
		document.getElementById('content').innerHTML = data;
	}
}

/*
 *  Informacje o lekarzach
 */
function getDoctorsBCO(){
	theSAO.makeCall('GET', new getNursesVCO(), 'Text', true, 'cmd=doct');
}

/*
*  Informacje o wizytach pacjenta
*/
function getPatientVisitsBCO(target){
    //jeśli tabela z wizytami tego pacjenta nie została jeszcze pobrana, pobierz ją
    if(target.parentNode.getElementsByTagName('table')[0] == null){
        theSAO.makeCall('GET', new getPatientVisitsVCO(target), 'Text', true, 'cmd=pat_vis&num='+target.id);
    }
    //jeśli dane były już pobierane, wyświetl je ponownie
    else{
        //ponieważ nie jest generowane asynchroniczne żądanie pobrania danych które zwykle wywołuje VCO
	//należy VCO wywołać bezpośrednio
        //przekaż jako parametr informację o jakie dane chodzi
        var aVCO = new getPatientVisitsVCO(target);
        aVCO.notify(null);
    }
}
function getPatientVisitsVCO(target){//uaktualnia stronę po odebraniu danych
    this.target = target;
    
   	this.notify = function(data){
        if(data == null){
            //znajdź tabelę z wizytami
            var visitTable = this.target.parentNode.getElementsByTagName('table')[0];
            //sprawdź czy nie należy jej ukryć
            if(this.target.innerText == '-' || this.target.innerHTML =='-'){
                //jeśli tak zmień wyświetlany tekst (wersja IE i Firefox)
                this.target.innerHTML = this.target.innerText = '+';
                //ukryj tabelę
                visitTable.style.display = 'none';      
            }
            else{//jeśli tabela musi zostać wyświetlona
                //zmień wyświetlony tekst (wersja IE i Firefox)
                this.target.innerHTML = this.target.innerText = '-';
                //wyświetl tabelę
                visitTable.style.display = 'block';
            }
        }
        else{//jeśli tabela jeszcze nie istnieje, wstaw ją
            //zmień wyświetlony tekst (wersja IE i Firefox)
            this.target.innerHTML = this.target.innerText = '-';
            //wstaw tabelę z wizytami
            this.target.parentNode.innerHTML += data;
        }
	}
}

/*
*  Informacje  o wszystkich wizytach
*/
function getVisitsBCO(){
	theSAO.makeCall('GET', new getVisitsVCO(), 'Text', true, 'cmd=vis');
}
function getVisitsVCO(){//uaktualnia stronę po otrzymaniu danych
	this.notify = function(data){
		document.getElementById('content').innerHTML = data;
	}
}

/*
*  wyświetlenie powiązań pacjentów z pielęgniarzami
*/
function getPatientNurseAssignBCO(){
	theSAO.makeCall('GET', new getPatientNurseAssignVCO(), 'Text', true, 'cmd=ret_pat_nur');
}
//uaktualnia stronę po odebraniu danych oraz obsługuje mechanizm przeciągania i upuszczania
function getPatientNurseAssignVCO(){
	this.notify = function(data){
		
        var contentPane = document.getElementById('content');
        contentPane.innerHTML = data;
        //czyści stare lokalizacje z danych
        dropLocations = new Array();
        //zapisuje wszystkie lokalizacje nieuporządkowanych list
        calculateDropLocations(contentPane, 'ul');
        window.onresize = function(){
            calculateDropLocations(contentPane, 'ul');
        }
        //dodatkowa funkcja wywoływana przed standardową funkcją
        //rozpoczynającą przeciąganie
        startDraggingFunc  = function(event, aNode){
            //w tym momencie ta funkcja nic nie robi
        }
        //dodatkowa funkcja wywoływana po standardowej funkcji obsługującej
        //przeciąganie elementu
        draggingFunc = function(event, aNode){
            event = event || window.event;//jeśli event ma wartość null należy pobrać wartość z okna
            var aList = getDropLocation(event.clientX, event.clientY);
            var parent = aNode.parentNode;
            while(parent != null){
                if(aList == parent){
                    return;
                }
                parent = parent.parentNode
            }
            //Przeglądanie wszystkich list na które można upuszczać. Choć marnuje to dużo cykli
            //jeśli przeciąganie nie kończy się na żadnej z list, jest to niezbędne ponieważ
            //niektóre zdarzenia nie są przetwarzane jeśli do silnik JavaScript zostanie zapchany
            //zdarzeniami. Bardzo szybkie przeniesienie elementu może spowodować takie przeskoczenie
            //zdarzenia a to naprawi ewentualne problemy. 
            var listLength = dropLocations.length;
            for(var i = 0; i < listLength; i++){
                var aDropListLocation = dropLocations[i];
                aDropListLocation.node.style.border = "solid 1px";
            }
            if(aList){
                aList.style.border = "solid 3px";
            }
        }
        //dodatkowa funkcja do wywołania przed standardową funkcją obsługującą 
        //zakończenie przeciągania elementu
        stoppedDraggingFunc = function(event, aNode){
            event = event || window.event;//jeśli event ma wartość null należy pobrać wartość z okna
            aNode.style.top = "0px";
            aNode.style.left = "0px";
            
            aNode.origY = 0;
            aNode.origX = 0;
            var aList = getDropLocation(event.clientX, event.clientY);
            var parent = aNode.parentNode;
            while(parent != null){
                if(aList == parent){
                    return;
                }
                parent = parent.parentNode
            }
            if(aList){//element może być upuszczony poza listami
                aList.appendChild(aNode);
                //utwórz dwa obiekty do przenoszenia niezbędnych danych
                var mockEvent = new Object();
                var mockTarget = new Object();
                mockTarget.patientID = aNode.id;
                mockTarget.nurseID = aList.id;
                mockEvent.currentTarget = mockTarget;
                theController.dispatch('update_pat_nur', mockEvent);
            }
        }
        //zamień wszystkie elementy listy w elementy które można przenosić
        buildDraggables(contentPane, 'li', startDraggingFunc, draggingFunc, stoppedDraggingFunc); 
	}
}

/*
*  uaktualnienie powiązania pacjenta z pielęgniarzem
*/
function updatePatientNurseAssignBCO(target){
	theSAO.makeCall('POST', new updatePatientNurseAssignVCO(), 'Text', true, 'cmd=update_pat_nur&patID='+target.patientID +'&nurID=' + target.nurseID,null);
}

function updatePatientNurseAssignVCO(){//ponieważ błędy będą przesyłane w inny sposób
                                       //ta metoda notify będzie wywoływana jedynie po udanym
                                       //zapisaniu danych
	this.notify = function(data){
        //utwórz obiekt div umieszczony po prawej na górze strony do wyświetlania znikającego
        //napisu z informacją o poprawnym zapisaniu danych
        var aMessageDiv = document.getElementById('messageDiv');
        if(!aMessageDiv){
            aMessageDiv = document.createElement('div');
            aMessageDiv.id = 'messageDiv';
            aMessageDiv.style.height = '30px';
            aMessageDiv.style.width = '75px';
            aMessageDiv.style.position = 'absolute';
            aMessageDiv.style.top = '3px';
            document.getElementsByTagName('body')[0].appendChild(aMessageDiv);
        }
        aMessageDiv.innerHTML = 'Pacjent przypisany';
        setTimeout('document.getElementById("messageDiv").innerHTML=""',1500);
    }
}


/*
* Informacje o stanie magazynu
*/
function getInventoryBCO(){
    theSAO.makeCall('GET', new getInventoryVCO(), 'Text', true, 'cmd=cur_inv');
}
function getInventoryVCO(){
    this.notify = function(data){
		document.getElementById('content').innerHTML = data;
	}
}
/*
*  Informacje o stanie magazynu dostawcy
*/
function getSupplierInventoryBCO(){
    theSAO.makeCall('GET', new getSupplierInventoryVCO(), 'Text', true, 'cmd=sup_inv');
}
function getSupplierInventoryVCO(){
    this.notify = function(data){
		document.getElementById('content').innerHTML = data;
	}
}

/*
*  Wykres wartości magazynu
*/
function getInventoryChartBCO(){
    theSAO.makeCall('GET', new getInventoryChartVCO(), 'Text', true, 'cmd=inv_cost');
}
var aChart = null;//globalny wskaźnik wykresu
function getInventoryChartVCO(){
    this.notify = function(data){
        //wstaw HTML
        var HTML = '<h2>Wartość magazynu w dolarach</h2>';
        HTML += '<div style="width: 500px; border: solid 1px; padding: 20px;">';
        HTML += '<div id="chartContainer" style="width: 500px; height:300px;"></div>';
        HTML += '</div><input id="pie" type="button" value="Wykres kołowy" onclick="aChart.setType(this.id);aChart.show()">';
        HTML += '<input id="bar" type="button" value="Wykres słupkowy" onclick="aChart.setType(this.id);aChart.show()">';
       document.getElementById('content').innerHTML = HTML;
        //stwórz wykres
        var chartContainer = document.getElementById('chartContainer');
        var dataArray = data.split('_DeLiMiTeRsTrInG_');
        aChart = new SimplePlot(chartContainer, 'bar', 'Purple');
        aChart.addLabels(dataArray[0]);
        aChart.addStringDataSeries(dataArray[1], "Aktualna wartość magazynu");
        //wyświetl wykres
        aChart.show();
    }
}

