<?php
//wykorzystywane przez XML_RPC_Server przy dostarczaniu informacji w postaci XML
class ExposedInventoryListingVCO{
	function __construct($data){
		$this->data = $data;
	}
	function execute(){
        //stwórz tablicę do przechowywania zarówno nagłówków jak i rekordów
        $values = array();
        //utwórz tablicę do przechowywania informacji o nagłówkaaa
        $headers = array();
        
        $numRecords = -1;
        foreach ($this->data as $fieldName => $field) {
            //utwórz obiekt XML_RPC_Value by otrzymać każdy nagłówek w postaci ciągu znaków
            $aHeader = new XML_RPC_Value($fieldName, "string");
            //dodaj wszystkie nagłówki do tablicy
            $headers[] = $aHeader;
			if($numRecords == -1){
				$numRecords = sizeof($field);
			}
		}
        //umieść nagłówki w tablicy wartości jako zmienną tablicową
        $values[] = new XML_RPC_Value($headers, "array");
        //utwórz tablicę do przechowywania wszystkich rekordów w postaci obiektów XML_RPC_Value
		$records = array();
		for ($i = 0; $i < $numRecords; $i++) {
			$aRecord = array();
			foreach ($this->data as $field) {
                //zapisz każde pole jako typ string ponieważ nie ma to żadnego znaczenia
                //dla PHP po drugiej stronie
                $aValue = new XML_RPC_Value($field[$i], "string");
				$aRecord[] = $aValue;
			}
            //zapisz każdy rekord jako wartość XML_RPC_Value typu tablicowego
            $aRecordVal = new XML_RPC_Value($aRecord, "array");
            //dodaj każdy rekord do tablicy rekordów
			$records[] = $aRecordVal;
		}
        //umieść rekordy w tablicy wartości jako typ tablicowy
        $values[] = new XML_RPC_Value($records, "array");
        //utwórz XML_RPC_Response dla klienta za pomocą XML_RPC_Value do przechowywania tablicy wartości
        $returnValue = new XML_RPC_Response(new XML_RPC_Value($values, "array"));
        //zwróć odpowiedź by wywołująca funkcja mogła przekazać ją do wysłania przez serwer
        return $returnValue;
	}
}
?>
