var dropLocations = new Array();
function calculateDropLocations(aContainer, nodeType){
    //get all of the nodes that are the type nodeType in the content
    var anArray = aContainer.getElementsByTagName(nodeType);
    //get the length of the list so an invariant for loop can be used
    var anArrayLength = anArray.length;
    for(var i = 0; i < anArrayLength; i++){
        var aPoint = getUpperLeftPoint(anArray[i]);
        var aListLocation = new Object();
        aListLocation.point = aPoint;
        aListLocation.node = anArray[i];
        dropLocations[i] = aListLocation;
    }
    dropLocations.sort(sortLeftToRight);
}
function getDropLocation(x, y){
    var listLength = dropLocations.length;
    //examine all drop locations
    for(var i = 0; i < listLength; i++){
        var aDropLocation = dropLocations[i];
        //calculate the bounds of the potential drop location
        var left = aDropLocation.point.leftValue - oldScrollAmount.x;
        var right = left + aDropLocation.node.offsetWidth;
        var top = aDropLocation.point.topValue - oldScrollAmount.y;
        var bottom = top + aDropLocation.node.offsetHeight;
        //check if this location contains the drag event point
        if(left < x && right > x
            && top < y && bottom > y){
            
            return aDropLocation.node;
        }
    
    }
    return null;
}
function sortLeftToRight(location1, location2){
    return location1.point.leftValue - location2.point.leftValue;
}
function getUpperLeftPoint(aNode){
    var aPoint = new Object()
    aPoint.leftValue = aNode.offsetLeft;
    aPoint.topValue = aNode.offsetTop;
	  while((aNode = aNode.offsetParent) != null){
            aPoint.leftValue += aNode.offsetLeft;
            aPoint.topValue += aNode.offsetTop;
	  }
	  return aPoint;
}

//this function must be set in the html file as the function for the onscroll event or it will not be fired
function docScrolled(event){
    event = event || window.event;
    var curDraggable = document.body.draggable;
    if(document.body.draggable){
        var currentScrollAmountY = getScrollAmountTop();
        var currentScrollAmountX = getScrollAmountLeft();
        
        var scrollChangeX = currentScrollAmountX - oldScrollAmount.x
        var scrollChangeY = currentScrollAmountY - oldScrollAmount.y
        oldScrollAmount.x = currentScrollAmountX;
        oldScrollAmount.y = currentScrollAmountY;
        
        var curTop  = curDraggable.top + scrollChangeY;
        var curLeft = curDraggable.left + scrollChangeX;
        
        var dragTop = curDraggable.top + currentScrollAmountY;
        var dragLeft = curDraggable.left +currentScrollAmountX;
        curDraggable.top = curTop;
        curDraggable.left = curLeft;
        
        curDraggable.style.top = curTop+'px';
        curDraggable.style.left = curLeft+'px';
                 
        
        if(curDraggable.top.whenDragging){
            curDraggable.whenDragging(event, curDraggable);
        }   

    }
}
function buildDraggables(aContainer, nodeType, startDraggingFunc, draggingFunc, droppedFunc){
    //get all of the nodes that are the type nodeType in the content
    var anArray = aContainer.getElementsByTagName(nodeType);
    //get the length of the list so an invariant for loop can be used
    var anArrayLength = anArray.length;
    for(var i = 0; i < anArrayLength; i++){
        var aNode = anArray[i];
        makeDraggable(aNode);
        aNode.whenStartDragging = startDraggingFunc;
        aNode.whenDragging = draggingFunc;
        aNode.whenDropped = droppedFunc;
        aNode.onselectstart = function() {
            return false; 
        };
    }
    oldScrollAmount.x = getScrollAmountLeft();
    oldScrollAmount.y = getScrollAmountTop();
}
var oldScrollAmount = new Object();
oldScrollAmount.x = 0;
oldScrollAmount.y = 0;
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

function makeDraggable(aNode){
    if(aNode.style){//pozycja może być względna lub bezwzględna
        //poniższe wartości nie muszą być opisywane stylem
        aNode.origPosType = aNode.style.position = aNode.style.position || 'relative';
        aNode.style.top = aNode.style.top || "0px";
        aNode.origX = aNode.style.left = aNode.style.left || "0px";
        
        aNode.origY = aNode.style.top.replace("px", "")*1;//wymuś żeby była to liczba całkowita, aby dodawanie nie było traktowane jak dopisywanie znaków do ciągu
        aNode.origX = aNode.style.left.replace("px", "")*1;
    }
    else{//jeśli nie ma żadnego stylu
        aNode.origPosType = aNode.style.position = 'relative';
        aNode.style.top = "0px";
        aNode.style.left = "0px";
        
        aNode.origY = 0;
        aNode.origX = 0;
    }
    
    aNode.onmouseclick = function(event){
        this.isDragging = false;
    }
    //funkcja rozpoczynająca przeciąganie
    aNode.onmousedown = function(event){
        event = event || window.event;//aby zdarzenie dotarło do IE
    
        if(body.draggable){//jeśli w tym miejscu jest jeszcze poprzednio przeciągany obiekt musiał wystąpić błąd
            body.draggable.isDragging = false;
            body.draggable.style.top = aNode.origY+"px";
            body.draggable.style.left = aNode.origX+"px";
            
            body.draggable.oldMouseY = body.draggable.origY;
            body.draggable.oldMouseX = body.draggable.origX;
        }
        this.top = aNode.origY;
        this.left = aNode.origX;
        if(this.whenStartDragging){
            this.whenStartDragging(event, this);
        }
        this.isDragging = true;
        this.style.zIndex = 500;
        //zmień poprzednie położenie na aktualne
        this.oldMouseX = event.clientX;
        this.oldMouseY = event.clientY;
        body.draggable = this;
        
        oldScrollAmount.x = getScrollAmountLeft();
        oldScrollAmount.y = getScrollAmountTop();
    };
    //funkcja kończąca przeciąganie
    aNode.onmouseup = function(event){
        if(this.whenDropped){
            this.whenDropped(event, this);
        }
        if(this.parentNode.style){
            this.style.zIndex = this.parentNode.style.zIndex;//cofnij
        }
        else{
            this.style.zIndex = 0;
        }
        this.isDragging = false;
        body.draggable.isDragging = false;
        body.draggable = null;
        
    };
    //funkcja obsługująca przeciąganie
    aNode.onmousemove = function(event){
        if(this.isDragging){
            event = event || window.event;//upewnij się że IE otrzymał zdarzenie
            var curY = event.clientY + getScrollAmountTop() - oldScrollAmount.y;
            var curX = event.clientX + getScrollAmountLeft() - oldScrollAmount.x;

            this.top += curY - this.oldMouseY;
            this.left += curX - this.oldMouseX;

            
            this.style.top = this.top+'px';
            this.style.left = this.left+'px';         
            this.oldMouseX = event.clientX;
            this.oldMouseY = event.clientY;
            if(this.whenDragging){
                this.whenDragging(event, this);
            }   
        }
    };
    aNode.setLocation = function (x, y){
        this.dragging = true;
        this.oldMouseX = this.oldMouseX || 0;
        this.oldMouseY = this.oldMouseY || 0;
        var simulatedDragEvent = new Object();
        simulatedDragEvent.clientX = x;
        simulatedDragEvent.clientY = y;
        this.onmousemove(simulatedDragEvent);
        this.dragging = false;
    }
    
   var body = document.getElementsByTagName('body')[0];
   if(!body.onmousemove){
        body.onmousemove = function(event){//obsługa błędu występującego gdy mysz przeciągnie poza przeciągalny Element
            if(body.draggable && body.draggable.isDragging){
                body.draggable.onmousemove(event);
            }
        };
   }
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////




function getViewableHeight(){
    var viewableHeight = null;
    if(window.innerHeight){
   		viewableHeight = window.innerHeight;
	}
	else if(document.documentElement && document.documentElement.clientHeight){
		viewableHeight = document.documentElement.clientHeight;
	}
	else if(document.body){
		viewableHeight = document.body.clientHeight;
	}
    return viewableHeight;
}
function getViewableWidth(){
    var viewableWidth = null;
    if(window.innerWidth){
        viewableWidth = window.innerHeight;
	}
	else if(document.documentElement && document.documentElement.clientWidth){
		viewableWidth = document.documentElement.clientWidth;
	}
	else if(document.body){
		viewableWidth = document.body.clientWidth;
	}
    return viewableWidth;
}
function getScrollAmountTop(){
    var amountOfScroll = null;
    if(document.documentElement && document.documentElement.scrollTop) {
        amountOfScroll = document.documentElement.scrollTop;
    }
    else if (document.body) {
        amountOfScroll = document.body.scrollTop;
    }
    return amountOfScroll;
 }
 function getScrollAmountLeft(){
    var amountOfScroll = null;
    if(document.documentElement && document.documentElement.scrollLeft) {
        amountOfScroll = document.documentElement.scrollLeft;
    }
    else if (document.body) {
        amountOfScroll = document.body.scrollLeft;
    }
    return amountOfScroll;
 }
 function stopStandardBehavior(event){
	   /*
		* stop the event from actually following the default behavior
		*/
	    if(!event)
		   event = window.event;
		if(event){
			if (event.preventDefault)
					event.preventDefault();
			event.returnValue = false;
		}
	}
