<?php
//pencilConstructorInheritance.php
	/*
	 * Ten plik należy uruchamiać z linii poleceń.
	 * Aby dobrze działał po uruchomieniu z serwera należy zmienić znaki \n na <br />
	 */
class WoodenPencil extends Pencil{  
    protected $sharpness;  
    protected $lengthPercentage;  
    function __construct($color) {  //konstruktor obiektu WoodenPencil
        parent::__construct($color);  //wywołanie konstruktora obiektu Pencil
        $this->sharpness = 10.0;
        $this->lengthPercentage = 100.0;
    }
    public function sharpen($amount){ 
        $this->lengthPercentage -= $amount;
        $this->sharpness = 10.0;
    }
}
class MechanicalPencil extends Pencil{ 
    protected $leadPercentage;
    protected $leadSize; 
    function __construct($color) {  //konstruktor obiektu MechanicalPencil
        parent::__construct($color);  //wywołanie konstruktora obiektu Pencil
        $this->leadSize = 10.0;
        $this->leadPercentage = 100.0;
    }
    public function replaceEraser(){ 
        $this->eraserPercentage = 100.0;
    }
}
class Pencil{
    protected $writeColor; 
    protected $eraserPercentage; 
    function __construct($color) {  //konstruktor przyjmujący parametr zawierający kolor
        $this->writeColor = $color;
        $this->eraserPercentage = 100.0;
    }
    public function erase($amount){
        $this->eraserPercentage -= $amount;
    }
    public function describePencil(){  //dodatkowa metoda obiektu Pencil
        print("Kolor rysowania: ".$this->writeColor."\n");
        print("Gumki zostało: ".$this->eraserPercentage."\n");
    }
}
$aPencil = new Pencil("red");  //stwórz nowy czerwony ołówek
$aPencil->describePencil();  //każ mu się opisać
print("Ołówek drewniany (obiekt WoodenPencil)\n");
$aWoodenPencil = new WoodenPencil("czerwony");  //stwórz drewniany ołówek rysujący na czerwono
$aWoodenPencil->erase(15); 
$aWoodenPencil->describePencil(); 
print("\nOłówek mechaniczny (obiekt MechanicalPencil)\n");
$aMechanicalPencil = new MechanicalPencil("czarny");  //stwórz mechaniczny ołówek rysujący na czarno
$aMechanicalPencil->erase(25); 
$aMechanicalPencil->describePencil(); 
?>
