var theController = new Controller();//utwórz kontroler
function init(){
	//upewnij się że strona jest pusta
	document.getElementById('content').innerHTML='';
    loadFirstSubPage();
}

function Controller(){//konstruktor
	//mapa poprawnych poleceń
	this.acceptableCommands = {pat:'getPatients', nur:'getNurses',doct:'getDoctors', pat_vis:'getPatientVisits', vis:'getVisits', ret_pat_nur:'getPatientNurseAssign',
       update_pat_nur: 'updatePatientNurseAssign', cur_inv:'getInventory', sup_inv:'getSupplierInventory', cur_inv_cost:'getInventoryChart',
       login:'login', store:'storeSession', home:'goToHome', storeHome:'storeSession', showMashup:'mashup',  cr_rep:'getReportCreation', vw_all_rep:'getReportList', pv_rep:'getReportPreview', snd_rep:'storeReportDef',
clr_rep:'resetReportDef', vw_rep:'getReport', rm_rep:'removeReportDef'};
	//metoda dispatch jest wykorzystywana do obsługi wszystkich żądań
	this.dispatch = function(cmd, event){
        if(event == null){
            event = window.event;
        }
        //wywołaj metodę przerywającą domyślną obsługę zdarzenia 
        stopDefault(event);
        //jeśli użytkownik nie jest zalogowany i nie próbuje się zalogować w tej chwili
        //wyświetl ekran logowania
        if(!session.getAttribute('loggedIn') && cmd !='login'){
            var loginDisp = new showLoginVCO();
            loginDisp.notify(cmd);
        }
        //użytkownik jest zalogowany i potrzebuje dostępu do danych
        else{
            //sprawdź czy polecenie jest poprawne
            var cmdName = this.acceptableCommands[cmd];
            if(cmdName != null){
                var objName = cmdName+'BCO';
                //pobierz element związany ze zdarzeniem
                var target = null;//zmiana wprowadzona aby wspierać śledzenie historii
                if(event != null){
                    target = event.currentTarget || event.srcElement;//inne || IE
                }
                //wykorzystaj odwzorowania do utworzenia odpowiedniego obiektu kontrolnego
                new window[objName](target);
            }
       }
	}
}

//zatrzymanie domyślnej obsługi zdarzenia ponieważ będzie ono obsłużone przez BCO i VCO
function stopDefault(event){
    if(event){
        if (event.preventDefault)// nie IE
                event.preventDefault();
        event.returnValue = false;// IE
    }
}
//usuwanie białych znaków z początku i końca ciągu znaków
function trim(aString){
    return aString.replace(/^\s+|\s+$/g, '');
}
//sprawdzenie cookie logowania w safari
function checkLoginCookie(){
	var cookies = document.cookie.split(';');
    var numCookies = cookies.length;
	for(var i=0;i < numCookies;i++) {
		var aCookie = trim(cookies[i]);
		if (aCookie.indexOf('med_login') == 0){
                return true;
        }
	}
    return false;
}
