/*
* Statyczne zmienne klasy SimplePlot wykorzystywane są do definiowania kolorystyki wykresu.
*/
SimplePlot.BLUE = "Blue";
SimplePlot.Red = "Red";
SimplePlot.Green = "Green";
SimplePlot.Purple = "Purple";
SimplePlot.Cyan = "Cyan";
SimplePlot.Orange = "Orange";
/*
*  To jest konstruktor obiektu SimplePlot
*/
function SimplePlot(aDiv, plotType, colorScheme, width, height){
    
    this.layout = new Layout(plotType || "line");
    //ustaw domyślne wartości
    this.parent = aDiv || document.createElement('div');
    this.width = width || 500;
    this.height = height || 300;
    //sprawdź czy przeglądarka obsługuje SVG
    this.supportsSVG = document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#SVG","1.1");
    this.renderer = null;
    
    /*
    *  Definicje metod SimplePlot
    */
    
    /*
    * przygotuj rysunek do pokazania. Jest to metoda wewnętrzna biblioteki.
    */
    this.prepareRenderer = function(){
        //ponieważ dane i kolory wykresu są dynamiczne, może być on już wyrysowany przy pierwszym wyświetleniu
        if(!this.renderer){
            if(this.supportsSVG){
                var svg = SVGRenderer.SVG({"width": this.width, "height": this.height, "id":"chart"});
                this.parent.appendChild(svg);
                this.renderer = new SweetSVGRenderer(svg, this.layout);
            }
            else{
                var aCanvas = document.createElement("canvas");
                aCanvas.id = "chartCanvas" + (document.getElementsByTagName("canvase").length +1);
                aCanvas.width = this.width;
                aCanvas.height = this.height;
                this.parent.appendChild(aCanvas);
                this.renderer = new SweetCanvasRenderer(aCanvas, this.layout);
            }
            this.setLabelColor("black");
        }
    }
    /*
    *  uaktualnij przeglądarkę by wyświetlić wykres
    */
    this.show = function(){
        this.layout.evaluate();
        this.renderer.clear();
        this.renderer.render();
    }
    
    this.setLabelColor = function(colorName){
        var colorName = colorName.toLowerCase()+"Color";
        var aColor = Color[colorName]();
        if(this.renderer){
            this.renderer.options["axisLabelColor"] = aColor;
        }
    }
    
    /*
    *  Ta funkcja ustawia schemat kolorów do wykorzystania na wykresie
    */
    this.setColor = function(colorScheme){
        var themeName = "office" + (colorScheme || "Blue");
        var theme = PlotKit.Base[themeName]();
        if(this.renderer){
            MochiKit.Base.update(this.renderer.options, theme);
        }
        MochiKit.Base.update(this.layout.options, theme);
        this.setLabelColor("black");
    }
    this.setType = function(aChartType){
        this.layout.style = (aChartType || "line").toLowerCase();
    }
    
    /*
    *  Ta metoda ustawia etykiety do wyświetlenia z danymi
    */
    this.addLabels = function(labelString){
        var labelStringArray = null;
        if(labelString != null){
            if(labelString.indexOf(";")){
                labelStringArray = labelString.split(";");
            }
            else{
                labelStringArray = labelString.split(",");
            }
            
            var JSONString = labelStringArray.toJSONString();
            var tmpString = JSONString.substring(1,JSONString.length-1);
            if(tmpString.indexOf("]") == -1){//nie dwa elementy
                JSONString = "["
                var singleDataValues = tmpString.split(",");
                var numValues  = singleDataValues.length;
                for(var i = 0; i < numValues; i++){
                    if( i != 0){
                        JSONString += ", ";
                    }
                    var dataVal = singleDataValues[i].replace("\"","");
                    JSONString += "{\"label\": \""+dataVal+"\", \"v\": "+i+"}";
                }
                JSONString += "]";
                labelStringArray = JSONString.parseJSON();
            }
        }
        MochiKit.Base.update(this.layout.options, {xTicks:labelStringArray});
    }
    /*
    *  ta metoda usuwa wszystkie dane z wykresu
    */
    this.clearChartData = function(){
        this.layout.datasets = null;
    }
     /*
    *  Ta metoda dodaje nową serię danych do wyświetlenia
    */
    this.addStringDataSeries = function(dataString, seriesName){
        var dataStringArray = null;
        if(dataString.indexOf(";")){
            dataStringArray = dataString.split(";");
        }
        else{
            dataStringArray = dataString.split(",");
        }
        this.addArrayDataSeries(dataStringArray, seriesName);
    }
     /*
    *  Ta metoda dodaje nową serię danych do wyświetlenia
    */
    this.addArrayDataSeries = function(dataArray, seriesName){
        var JSONString = dataArray.toJSONString();
        var tmpString = JSONString.substring(1,JSONString.length-1);
        if(tmpString.indexOf("]") == -1){//nie dwa elementy
            JSONString = "["
            var singleDataValues = tmpString.split(",");
            var numValues  = singleDataValues.length;
            for(var i = 0; i < numValues; i++){
                if( i != 0){
                    JSONString += ",";
                }
                var dataValNum = singleDataValues[i].replace(/\"/g,"");
                JSONString += "["+i+","+dataValNum+"]";
            }
            JSONString += "]";
            JSONString = JSONString.parseJSON();
        }
        seriesName = seriesName || "Series "+(this.datasets.length +1);
        this.layout.addDataset(seriesName, JSONString);
    }
    this.prepareRenderer();
    this.setLabelColor("black");
    this.setColor(colorScheme);
}
