<?php
class localInventoryCostBCO{
	function __construct($data){
		$this->data = $data;
	}
	function execute(){
        //dołącz i wykorzystaj BCO do pobrania danych
		require_once getcwd().DIRECTORY_SEPARATOR.'localInventoryListingBCO.inc';//pobierz plik zawierający model danych
        $aListBCO = new LocalInventoryListingBCO($this->data);
        $results = $aListBCO->execute();
        //przygotuj tablice na dane do wykorzystania przez VCO
        $costArray = array();//tablica główna
        $costArray[] = array();//tablica na nazwy rzeczy
        $costArray[] = array();//tablica na sumaryczny koszt rzeczy
        //pobierz odpowiednie kolumny z danych odebranych od Oracle
        $descriptionArray = $results["ITEM_DESCRIPTION"];
        $priceArray = $results["ITEM_PRICE"];
        $pricePerArray = $results["ITEM_PRICE_PER"];
        $numInvArray = $results["ITEM_STOCK"]; 
        //oblicz wartość rzeczy każdego rodzaju w magazynie
        $numValues = sizeof($priceArray);
        for($i = 0; $i < $numValues; $i++){
            $aPrice = $priceArray[$i];//koszt grupy
            $aPricePer = $pricePerArray[$i];//rozmiar grupy
            $aNumInv = $numInvArray[$i];//ilość w magazynie
            //usuń wszystkie znaki poza cyframi
            $aPricePer = trim(ereg_replace('[a-zA-Z,\.]','',$aPricePer));//zamiana wszystkich liter i usunięcie początkowych oraz końcowych białych znaków
            //jeśli pozostał pusty ciąg znaków załóż że podana jest cena jednostkowa
            if(strlen($aPricePer) == 0){
                $aPricePer = 1;
            }
            $itemInventoryCost=$aPrice*$aNumInv/$aPricePer;//oblicz cenę jednostkową
            $costArray[0][] = $descriptionArray[$i];//zapisz nazwę rzeczy
            $costArray[1][] = $itemInventoryCost;//zapisz sumaryczny koszt rzeczy o tej nazwie
        }
        return $costArray;//zwróć tablicę wartości do obróbki w VCO
    }
}
?>
