<?php
include_once('XML/RPC.php');
class SupplierInventoryListingVCO{
	function __construct($data){
		$this->data = $data;
	}
	function execute(){
        //Dane zapisane w XML_RPC_Response Pear lub null jeśli wystąpił błąd.
        if($this->data){
            //pobierz nagłówek i tablicę rekordów
            $headersValueArray = $this->data->value()->arraymem(0);
            $recordsValueArray = $this->data->value()->arraymem(1);
            //ustal ilość pól i wierszy
            $numFields = $headersValueArray->arraysize();
            $numRecords = $recordsValueArray->arraysize();
            //rozpocznij tabelę
            print("<h2>Hurtownia Medyczna S.A. - Stan magazynu</h2>");
            print("<table border >\n<tr>\n");
            //wypisz nazwy pól jako nagłówki tabeli
            for($i = 0; $i < $numFields; $i++){
                //scalarval zawiera ciąg znaków do nagłówka z 
                //obiektu XML_RPC_Value z tablicy
                print("<th>".$headersValueArray->arraymem($i)->scalarval()."</th>");
            }
            print("</tr>\n");
            //wyświetl rekordy w wierszach tabeli
            for($i = 0; $i < $numRecords; $i++){
                //weź każdy rekord
                $aRecord = $recordsValueArray->arraymem($i);
                print("<tr>\n");
                for($j = 0; $j < $numFields; $j++){
                    //wyświetl każdy ciąg znaków zapisany w XML_RPC_Value w tablicy rekordu
                    print("<td>".$aRecord->arraymem($j)->scalarval()."</td>");
                }
                print("</tr>\n");
            }
            print("</table>\n");
        }
        else{
            print("<h3>System magazynowy dostawcy nie jest w tym momencie dostępny. Upewnij się że masz połączenie z internetem.</h3>");
        }
	}
}
?>
