<?php
//pencilAll.php
	/*
	 * Ten plik należy uruchamiać z linii poleceń.
	 * Aby dobrze działał po uruchomieniu z serwera należy zmienić znaki \n na <br />
	 */
	
class Pencil{
    protected $writeColor;  //kolorRysowania
    protected $eraserPercentage;  //procentGumki
    protected $bodyColor;  //nowy atrybut opisujący kolor uchwytu
    function __construct($color) {  //konstruktor przyjmujący parametr zawierający kolor
        $this->writeColor = $color;
        $this->eraserPercentage = 100.0;
    }
    public function erase($amount){
        $this->eraserPercentage -= $amount;
    }
    public function describePencil(){  //dodatkowa metoda obiektu Pencil
        print("Kolor rysowania: ".$this->writeColor."\n");
        print("Gumki zostało: ".$this->eraserPercentage."\n");
        print("Kolor uchwytu: ".$this->bodyColor."\n");
    }
}
class WoodenPencil extends Pencil{  //dziedzicz po obiekcie Pencil
    protected $sharpness;  //naostrzony
    protected $lengthPercentage;  //procentDlugosci
    function __construct($color) {  //konstruktor obiektu WoodenPencil
        parent::__construct($color);  //wywołanie konstruktora obiektu Pencil
        $this->sharpness = 10.0;
        $this->lengthPercentage = 100.0;
        $this->bodyColor = "żółty";  //ustawienie wartości odziedziczonego atrybutu bodyColor 
    }
    public function sharpen($amount){  //nie do wykonania w ołówku mechanicznym
        $this->lengthPercentage -= $amount;
        $this->sharpness = 10.0;
    }
}
class MechanicalPencil extends Pencil{  //dziedzicz po obiekcie Pencil
    protected $leadPercentage;  //procentDlugosci
    protected $leadSize;  //rozmiarGrafitu
    function __construct($color) {  //konstruktor obiektu MechanicalPencil
        parent::__construct($color);  //wywołanie konstruktora obiektu Pencil
        $this->leadSize = 10.0;
        $this->leadPercentage = 100.0;
        $this->bodyColor = "niebieski";  //ustawienie wartości odziedziczonego atrybutu bodyColor 
    }
    public function replaceEraser(){  //nie do wykonania w ołówku drewnianym
        $this->eraserPercentage = 100.0;
    }
}
print("Ołówek drewniany (obiekt WoodenPencil)\n");
$aWoodenPencil = new WoodenPencil("czerwony");  //stwórz drewniany ołówek
$aWoodenPencil->erase(15);  //skróć gumkę o 15%
$aWoodenPencil->describePencil();  //każ mu się opisać
print("\nOłówek mechaniczny (obiekt MechanicalPencil)\n");
$aMechanicalPencil = new MechanicalPencil("czarny");  //stwórz mechaniczny ołówek
$aMechanicalPencil->erase(25);  //skróć jego gumkę o 25%
$aMechanicalPencil->describePencil();  //każ mu się opisać
?>
