/*
 * get_president2.sql
 * Appendix D, Oracle Database AJAX and PHP Web Application Development
 * by Lee Barney and Michael McLaughlin
 *
 * Demonstrate working with a stored function.
 */

-- Unremark for debugging script.
SET PAGESIZE 999
SET SERVEROUTPUT ON SIZE 1000000


-- Define anonymous block PL/SQL program to test named notation.
DECLARE

  -- Declare local variables.
  t_start           NUMBER := '1914';
  t_end             NUMBER := '1943';
  t_country         VARCHAR2(3 CHAR) := 'USA';
  president_ids     WORLD_LEADERS.PRESIDENT_ID_TABLE;
  president_names   WORLD_LEADERS.PRESIDENT_NAME_TABLE;
  tenures           WORLD_LEADERS.TENURE_TABLE;
  parties           WORLD_LEADERS.PARTY_TABLE;

BEGIN

  -- Call the overloaded procedure.  
  get_presidents_procedure
  ( t_start
  , t_end
  , t_country
  , president_ids
  , president_names
  , tenures
  , parties);

  -- Read the contents of one of the arrays.
  FOR i IN 1..president_names.COUNT LOOP
    dbms_output.put     ('['||president_ids(i)||']');
    dbms_output.put     ('['||president_names(i)||']');
    dbms_output.put     ('['||tenures(i)||']');
    dbms_output.put_line('['||parties(i)||']');
  END LOOP;

END;
/  