<?php
  // Odbierz i przetwórz plik wysłany ze strony internetowej
  $biography = process_uploaded_file();

  // Zwróć połączenie z bazą danych
  if ($c = @oci_connect("app","badpass","//localhost/XE"))
  {
    // Zadeklaruj zmienne wejściowe
    (isset($_POST['id'])) ? $id = (int) $_POST['id'] : $id = 1;
    (isset($_POST['name'])) ? $name = $_POST['name'] : $name = "Washington";

    // Zadeklaruj polecenie PL/SQL
    $stmt = "UPDATE    president
             SET       biography = empty_clob()
             WHERE     president_id = :id
             RETURNING biography
             INTO      :descriptor";

    // Usuń znaki specjalne aby uniknąć błędów ORA-06550 i PLS-00103.
    $stmt = strip_special_characters($stmt);

    // Przetwórz wyrażenie w połączeniu
    $s = oci_parse($c,$stmt);

    // Zdefiniuj deskryptor dla CLOB
    $rlob = oci_new_descriptor($c,OCI_D_LOB);

    // Zdefiniuj nazwę do mapowania na deskryptor CLOB
    oci_define_by_name($s,':descriptor',$rlob,SQLT_CLOB);

    // Połącz zmienne PHP z typami OCI
    oci_bind_by_name($s,':id',$id);
    oci_bind_by_name($s,':descriptor',$rlob,-1,SQLT_CLOB);

    // Wykonaj wyrażenie PL/SQL.
    if (oci_execute($s,OCI_DEFAULT))
    {
       $rlob->save($biography);
       oci_commit($c);
       query_insert($id,$name);
    }

    // Zamknij połączenie z bazą danych
    oci_close($c);
  }
  else
  {
    // Pobierz błąd OCI i odpowiednio sformatuj
    $errorMessage = oci_error();
    print htmlentities($errorMessage['message'])."<br />";
  }

  // Pobierz zmodyfikowany wiersz
  function query_insert($id,$name)
  {
    // Zwróć połączenie z bazą danych
    if ($c = @oci_new_connect("app","badpass","//localhost/XE"))
    {
      // Zadeklaruj wyrażenie PL/SQL zwracające CLOB
      $stmt = "SELECT   biography
               FROM     president
               WHERE    president_id = :id";

      // Przetwórz wyrażenie w połączeniu
      $s = oci_parse($c,$stmt);

      // Połącz zmienne PHP z typami OCI
      oci_bind_by_name($s,':id',$id);

      // Wykonaj wyrażenie PL/SQL
      if (oci_execute($s))
      {
        // Zwróć deskryptor LOB jako wartość
        while (oci_fetch($s))
        {
          for ($i = 1;$i <= oci_num_fields($s);$i++)
            if (is_object(oci_result($s,$i)))
            {
              if ($size = oci_result($s,$i)->size())
                $data = oci_result($s,$i)->read($size);
              else
                $data = "&nbsp;";
            }
            else
            {
              if (oci_field_is_null($s,$i))
                $data = "&nbsp;";
              else
                $data = oci_result($s,$i);
            }
        } // Koniec pętli while(oci_fetch($s))

        // Sformatuj tabelę HTML wyświetlającą biografię
        $out = '<table border="1" cellpadding="3" cellspacing="0">';
        $out .= '<tr>';
        $out .= '<td align="center" class="e">'.$name.' - biografia</td>';
        $out .= '</tr>';
        $out .= '<tr>';
        $out .= '<td class="v">'.$data.'</td>';
        $out .= '</tr>';
        $out .= '</table>';
      }

      // Wyświetl tabelę HTML
      print $out;

      // Zakończ połączenie z bazą danych
      oci_close($c);
    }
    else
    {
      // Pobierz błąd OCI i odpowiednio sformatuj
      $errorMessage = oci_error();
      print htmlentities($errorMessage['message'])."<br />";
    }
  }

  // Pobierz wysyłany plik i zwróć go w postaci ciągu znaków
  function process_uploaded_file()
  {
    // Zadeklaruj zmienną na zawartość pliku
    $contents = "";

    // Określ nazwę wysyłanego pliku dla systemów Windows i Linux
    if (ereg("Win32",$_SERVER["SERVER_SOFTWARE"]))
      $upload_file = getcwd()."\\temp\\".$_FILES['userfile']['name'];
    else
      $upload_file = getcwd()."/temp/".$_FILES['userfile']['name'];

    // Sprawdź i przenieś przesłany plik
    if (is_uploaded_file($_FILES['userfile']['tmp_name']))
      move_uploaded_file($_FILES['userfile']['tmp_name'],$upload_file);

    // Otwórz plik i zignoruj błąd w przypadku braku pliku
    if ($fp = @fopen($upload_file,"r"))
    {
      // Odczytaj do znacznika końca pliku
      while (!feof($fp))
        $contents .= fgetc($fp);

      // Zamknij otwarty plik
      fclose($fp);
    }

    // Zwróć zawartość pliku jako ciąg znaków
    return $contents;
  }

  // Usuwa znaki specjalne takie jak znaki nowej linii i tabulacje
  function strip_special_characters($str)
  {
    $out = "";
    for ($i = 0;$i < strlen($str);$i++)
      if ((ord($str[$i]) != 9) && (ord($str[$i]) != 10) &&
          (ord($str[$i]) != 13))
        $out .= $str[$i];

    // Zwraca wstępnie przetworzone wyrażenie SQL
    return $out;
  }
?>
