/*
 * This library depends on the drag and drop
 * library found in the util.js file.
 */

MashFrame.mashCount = 0;
MashFrame.mashArray = new Array();

function MashFrame(aURL, parentID, xLoc, yLoc, width, height, scrollDown, scrollRight){
     MashFrame.mashArray[MashFrame.mashArray.length] = this;
    MashFrame.mashCount = MashFrame.mashArray.length;
    
    var parent = document.getElementById(parentID);
    if(aURL.indexOf('http:') != 0){
        aURL = 'http://'+aURL;
    }
    var mashFrameName = 'mashFrame'+MashFrame.mashCount;
    //create the elements required for display
    this.iframe = document.createElement('iframe');
    this.iframe.id = this.iframe.name = mashFrameName;
    
    this.resizableContainer = document.createElement('div');
    this.movableContentContainer = document.createElement('div');
    this.topMoveDiv = document.createElement('div');
    this.rightResizeDiv = document.createElement('div');
    this.leftResizeDiv = document.createElement('div');
    this.bottomResizeDiv = document.createElement('div');
    this.closeDiv = document.createElement('div');
    //setup the iframe
    this.iframe.src = aURL;
    this.iframe.style.width = '1000px';
    this.iframe.style.height = '5000px';
    this.iframe.style.position = 'relative';
    this.iframe.style.top = '0px';
    this.iframe.style.left = '10px';
    
    this.resizableContainer.className = 'resizableContainer';
    this.resizableContainer.style.zIndex = this.resizableContainer.style.zIndex*1 + MashFrame.mashCount*1 + 49;
    var aBaseLocation = getUpperLeftPoint(parent);
    //set the defined location and size
    this.origXLoc = xLoc || 0;
    //this.origXLoc += aBaseLocation.leftValue;
    this.resizableContainer.style.left = this.origXLoc;
    
    this.origYLoc = yLoc || 0;
    //this.origYLoc += aBaseLocation.topValue;
    this.resizableContainer.style.top = this.origYLoc;
    
    this.origWidth = width || 300;
    this.curWidth = this.width = this.origWidth;
    this.resizableContainer.style.width = this.origWidth+'px';
    
    this.origHeight = height || 294;
    this.curHeight = this.height = this.origHeight;
    this.resizableContainer.style.height = this.origHeight+'px';
    
    this.origScrollDown = -(scrollDown || 0);
    
    this.origScrollRight = -(scrollRight || 0);
    
    
    //setup the dragging div
    
    this.topMoveDiv.left = 0;
    this.topMoveDiv.className = 'topMove';
    this.topMoveDiv.whenStartDragging = mashSelected;
    this.topMoveDiv.whenDropped = mashDeSelected;
    this.topMoveDiv.whenDragging = moveMash;
    this.topMoveDiv.mashFrame = this;
    this.resizableContainer.appendChild(this.topMoveDiv);
    makeDraggable(this.topMoveDiv);
     
    //setup the viewable window
    //is windows
    //the default height is 294 and width is 300
    if(navigator.platform.indexOf('Win') != -1){
        this.movableContentContainer.style.width = (this.origWidth - 20)+'px';
        this.movableContentContainer.style.height = (this.origHeight)+'px';
        this.movableContentContainer.style.overflow = 'auto';
    }
    //not windows.  Only tested on OS X.  Linux not tested.
    else{
        this.movableContentContainer.style.width = (this.origWidth - 8)+'px';
        this.movableContentContainer.style.height = (this.origHeight - 2)+'px';
    }
    
    this.movableContentContainer.style.margin = '4px';
    this.movableContentContainer.style.marginTop = '0px';
    
    //not windows
    if(navigator.platform.indexOf('Win') != -1){
        this.movableContentContainer.style.marginLeft = '15px';
        this.resizableContainer.style.marginLeft = '0px';
        this.iframe.style.marginLeft = '-10px';
    }
    this.resizableContainer.appendChild(this.movableContentContainer);
    //insert the iframe into the viewable window
    this.movableContentContainer.appendChild(this.iframe);
    
    this.glassPane = document.createElement('div');
    this.glassPane.style.width = '2000px';
    this.glassPane.style.height = '5000px';
    this.glassPane.style.position = 'relative';
    this.glassPane.style.marginTop = '-5000px';
    
    this.movableContentContainer.appendChild(this.glassPane);
    this.glassPane.iframe = this.iframe;
    this.glassPane.ignoreScrolling = true;
    //not windows
    if(navigator.platform.indexOf('Win') == -1){
        this.glassPane.style.cursor = 'move';
        this.movableContentContainer.style.overflow = 'hidden';
        makeDraggable(this.glassPane);
        
        //adjust the viewable area
        this.iframe.style.top = this.origScrollDown +'px';
        this.iframe.style.left = this.origScrollRight + 'px';
    }
    
    this.glassPane.mashFrame = this;
    
    this.glassPane.whenDragging = function(){
        this.iframe.style.top = (this.top + this.mashFrame.origScrollDown)+'px';
        this.iframe.style.left = (this.left + this.mashFrame.origScrollRight) + 'px';
    };
     
    parent.appendChild(this.resizableContainer);
    
    
    this.resizableContainer.parentNode.onmousemove = function(event){
        stopStandardBehavior(event);
    }
    
   
    //setup each of the resizing divs
    
    this.leftResizeDiv.left = 0;
    this.leftResizeDiv.style.marginTop = -(this.origHeight+6);
	var shift = 4;
	if(navigator.platform.indexOf('Win') != -1){
		shift = 2;
	}
    this.leftResizeDiv.style.height = (this.origHeight + shift)+'px';
    this.leftResizeDiv.className = 'leftResize';
    this.resizableContainer.appendChild(this.leftResizeDiv);
    makeDraggable(this.leftResizeDiv);
    this.leftResizeDiv.whenStartDragging = mashSelected;
    this.leftResizeDiv.whenDropped = mashDeSelected;
    this.leftResizeDiv.mashFrame = this;
    this.leftResizeDiv.whenDragging = changeWidth;
    
        
    this.rightResizeDiv.narrowShift = 0;
    this.rightResizeDiv.style.marginTop = -(this.origHeight+15);
    this.rightResizeDiv.style.height = (this.origHeight + 21)+'px';
    this.rightResizeDiv.style.left = (this.origWidth - 4)+'px';
    this.rightResizeDiv.className = 'rightResize';
    this.resizableContainer.appendChild(this.rightResizeDiv);
    makeDraggable(this.rightResizeDiv);
    this.rightResizeDiv.whenStartDragging = mashSelected;
    this.rightResizeDiv.whenDropped = mashDeSelected;
    this.rightResizeDiv.mashFrame = this
    this.rightResizeDiv.whenDragging = changeWidth
	//if is windows
    if(navigator.platform.indexOf('Win') != -1){
		//if is IE
		if(navigator.userAgent.indexOf('MSIE') != -1){
			this.rightResizeDiv.style.marginTop = -(this.origHeight+19);
			this.rightResizeDiv.style.height = (this.origHeight + 38)+'px';
		}
		else{
			this.rightResizeDiv.style.marginTop = -(this.origHeight+15);
			this.rightResizeDiv.style.height = (this.origHeight + 30)+'px';
		}
    }
    
    this.bottomResizeDiv.className = 'bottomResize';
	shift = 11;
	var topShift = 0;
    //is windows
    if(navigator.platform.indexOf('Win') != -1){
		shift = 0;
		topShift = -7;
		if(navigator.userAgent.indexOf('MSIE') != -1){
			topShift = -11;
		}
	}
    this.bottomResizeDiv.style.width = (this.origWidth + shift)+'px';
    this.resizableContainer.appendChild(this.bottomResizeDiv);
    makeDraggable(this.bottomResizeDiv);
    this.bottomResizeDiv.whenStartDragging = mashSelected;
    this.bottomResizeDiv.whenDropped = mashDeSelected;
    this.bottomResizeDiv.mashFrame = this
    this.bottomResizeDiv.whenDragging = changeHeight;
	this.bottomResizeDiv.style.top = topShift + 'px';
    
    //setup the close div
    var closeImage = document.createElement('img');
    closeImage.src = 'close.gif';
    closeImage.mashFrame = this;
    this.closeDiv.appendChild(closeImage);
    closeImage.onclick = function(){
        if(confirm('Remove '+this.mashFrame.iframe.src+' ?')){
            var aFrame = this.mashFrame;
            var numFrames = MashFrame.mashArray.length;
            for(var i = 0; i < numFrames; i++){
                if (MashFrame.mashArray[i] == aFrame) {
                    MashFrame.mashArray.splice(i, 1);
                    var tmpParent = this.mashFrame.resizableContainer.parentNode;
                    this.mashFrame.resizableContainer.parentNode.removeChild(this.mashFrame.resizableContainer);
                    break;
                }
            }
            MashFrame.mashCount  = MashFrame.mashArray.length;
        }
    }
    
    this.closeDiv.className = 'closeFrame';
    closeImage.className = 'closeFrame';
    this.rightResizeDiv.appendChild(this.closeDiv);
    
    
	//if is windows
    if(navigator.platform.indexOf('Win') != -1){
        //adjust the viewable area
        this.movableContentContainer.scrollTop = scrollDown;
        this.movableContentContainer.scrollLeft = scrollRight;
    }
}

function moveMash(event){
    //make sure that the values are treated as numbers instead of strings
    this.mashFrame.resizableContainer.style.top = (this.mashFrame.origYLoc*1 + this.top*1)+'px';
    this.mashFrame.resizableContainer.style.left = (this.mashFrame.origXLoc*1 + this.left+this.mashFrame.leftResizeDiv.left*1)+'px';
    this.style.top = '0px';
    this.style.left = '0px';
}

function changeHeight(event){
	this.mashFrame.heightChanged = true;//a hack for windows Firefox and IE
    this.mashFrame.curHeight = (this.mashFrame.curHeight*1)+(this.yDiff*1);

    this.mashFrame.movableContentContainer.style.height = this.mashFrame.curHeight+'px';
    var shift = shiftTop = 0;
	var rightShiftTop = 2;
	var rightShiftHeight = 18;
    if(navigator.platform.indexOf('Win') != -1){
        shift = 0;
        shiftTop = -9;
		rightShiftTop = 2;
		rightShiftHeight = 30;
		if(navigator.userAgent.indexOf('MSIE') != -1){
			rightShiftHeight = 38;
			shiftTop = -13;
		}
    }
	this.mashFrame.rightResizeDiv.style.height = (this.mashFrame.curHeight + rightShiftHeight)+'px'
	this.mashFrame.rightResizeDiv.style.top = rightShiftTop+2*(this.mashFrame.origHeight - this.mashFrame.curHeight)+'px';
    this.mashFrame.leftResizeDiv.style.height = (this.mashFrame.curHeight+shift)+'px';
    this.mashFrame.leftResizeDiv.style.top = (this.mashFrame.origHeight - this.mashFrame.curHeight+2)+'px';
    
    this.style.top = shiftTop+2*(this.mashFrame.origHeight - this.mashFrame.curHeight+2)+'px';
    this.style.left = '0px';
}
function changeWidth(event){
	var widthShift = 0;
    if(this.className == 'leftResize'){
        this.mashFrame.curWidth = (this.mashFrame.curWidth*1)-(this.xDiff*1);
        //make sure the values are treated as numbers not strings
        var newLeft = ((this.mashFrame.origXLoc*1) + (this.left*1)+(this.mashFrame.topMoveDiv.left*1))+'px';
        this.mashFrame.resizableContainer.style.left = newLeft;
        var shift = -4;
        if(navigator.platform.indexOf('Win') != -1){
            shift = -4;
			widthShift = -20;
        }
        this.mashFrame.rightResizeDiv.style.left = (this.mashFrame.curWidth+shift)+'px';
        //this.mashFrame.rightResizeDiv.style.left = this.mashFrame.curWidth - this.mashFrame.origWidth + 'px';
        this.mashFrame.rightResizeDiv.narrowShift -= this.xDiff;
        this.style.left = '0px';
        this.style.top = (this.mashFrame.origHeight - this.mashFrame.curHeight+2)+'px';
    }
    else{
        var shift = 5;
		//if windows
        if(navigator.platform.indexOf('Win') != -1){
            shift = 2;
			//this is a hack for Firefox and IE on windows.
			//without this and line 1 in changeHeight a 
			//2 pixel shift happens to the top of the 
			//right resize div if the mash frame 
			//has not been resized.
			if(!this.mashFrame.heightChanged){
				shift = 0;
			}
		
			widthShift = -20;
        }
        this.mashFrame.curWidth = (this.mashFrame.curWidth*1)+(this.xDiff*1);
        this.style.left = (this.left + this.narrowShift) +'px';
        this.style.top = shift+2*(this.mashFrame.origHeight - this.mashFrame.curHeight)+'px';
    }
    var shift = 11;
    if(navigator.platform.indexOf('Win') != -1){
        shift = 0;
    }
    this.mashFrame.movableContentContainer.style.width = (this.mashFrame.curWidth + widthShift) + 'px';
    this.mashFrame.topMoveDiv.style.width = this.mashFrame.bottomResizeDiv.style.width = (this.mashFrame.curWidth+shift)+'px';
}

function mashSelected(){
    this.mashFrame.parentActive = true;
    var numMash = MashFrame.mashArray.length;
    for(var i = 0; i < numMash; i++){
        if( MashFrame.mashArray[i].resizableContainer.style.zIndex >= this.mashFrame.resizableContainer.style.zIndex){
             MashFrame.mashArray[i].resizableContainer.style.zIndex =  MashFrame.mashArray[i].resizableContainer.style.zIndex - 1;
        }
    }
    this.mashFrame.resizableContainer.style.zIndex = 49+MashFrame.mashCount;
}
function mashDeSelected(){
    this.mashFrame.parentActive = false;
}
function getMashupDescriptor(){
    
    var descriptorArray = new Array();
    
    var numFrames =  MashFrame.mashArray.length;
    for(var i = 0; i < numFrames; i++){
        var aMashFrame =  MashFrame.mashArray[i];
        var aDescriptorMap = new Object();
        aDescriptorMap.URL = aMashFrame.iframe.src;
        aDescriptorMap.top = aMashFrame.resizableContainer.style.top.split('px')[0];
        aDescriptorMap.left = aMashFrame.resizableContainer.style.left.split('px')[0];
        aDescriptorMap.width = aMashFrame.curWidth;
        aDescriptorMap.height = aMashFrame.curHeight;
        //if is windows
        if(navigator.platform.indexOf('Win') != -1){
            aDescriptorMap.scrollDown = aMashFrame.movableContentContainer.scrollTop;
            aDescriptorMap.scrollRight = aMashFrame.movableContentContainer.scrollLeft;
        }
        //not windows
        else{
            aDescriptorMap.scrollDown = aMashFrame.iframe.style.top.split('px')[0]*-1;
            aDescriptorMap.scrollRight = aMashFrame.iframe.style.left.split('px')[0]*-1;
            
        }
        descriptorArray[i] = aDescriptorMap;
        
    }
    return descriptorArray;
}


function getWidth(aNode){
    return aNode.offsetWidth;
}
function getHeight(aNode){
    return aNode.offsetHeight;
}
function requestNewMashFrame(parentID){
    var aURL = prompt('Please enter the URL of the desired page');
    if(aURL){
        new MashFrame(aURL, parentID);
    }
}
