var theSAO = new ServerAO('main.php');//punkt dostępu po stronie serwera obsługujący całą komunikację
/*
*  W zależności od polecenie wysłanego przez serwer 
*  pewne rodzaje błędów powodują wywołanie odpowiednich
*  VCO obsługujących te błędy.
*/
function ErrorHandlerVCO(){
	this.acceptableErrorCommands = {showErrorMessage:'showErrorDialog', badLogin:'showBadLogin', storeReportFailure:'showStoreReportFailure', noAllowedReport:'showReportError'};
    
    this.notify = function(data){
        //oddziel polecenie od innych komunikatów nietypowym ciągiem znaków (_DeLiMiTeRsTrInG_)
        var dataArray = data.split("_DeLiMiTeRsTrInG_");
        //pobierz polecenie
		var commandName = dataArray[0];
        var vcoName = null;
        //jeśli polecenie jest wymienione na liście poprawnych poleceń
        //wygeneruj nazwę VCO do utworzenia
        if(commandName != null){
            vcoName = this.acceptableErrorCommands[commandName]+"VCO";
        }
        if(vcoName != null){
            //utwórz VCO obsługujące błąd
            var aVCO = new window[vcoName]();
            //uruchom kod obsługujący błąd w VCO
            aVCO.notify(dataArray[1]);
        }
	}
    
}
/*
* Wyświetlenie okna z dynamicznie zmienianym komunikatem
*/
function showErrorDialogVCO(){
    this.notify = function(data){
        alert(data);
    }
}
/*
* Ekran wyświetlający informację o błędzie logowania zarówno w 
* przypadku niepoprawnych danych jak i brakujących parametrów
*/
function showBadLoginVCO(){
    this.notify = function(){
        session.addAttribute('badLogin', true);
        updateURL("badLogin", null);
    }
}
/*
 *
 */
function showStoreReportFailureVCO(){
    this.notify = function(){
        document.getElementById('reportWarningDiv').innerHTML = 'Zapisanie raportu w tej chwili nie jest możliwe. Proszę spróbować później.';
    }
}
function showReportErrorVCO(){
    this.notify = function(){
        updateURL("vw_all_rep", null);
    }
}
function showLoginVCO(){
    this.notify = function(data){
        if(data != 'login'){
            //sposób na odnalezienie widocznych pól wprowadzania danych w Safari
            var loginDisplayContent = document.getElementById('loginHolder').innerHTML;
            //usuń wszystkie wystąpienia 'Stored'
            //loginDisplayContent = loginDisplayContent.replace("Stored",'','g');
            loginDisplayContent = loginDisplayContent.replace(/Stored/g,'');
            //wyświetl ekran logowania
            document.getElementById('content').innerHTML = loginDisplayContent;
            if(session.getAttribute('badLogin')){
                var loginErrorMsg = document.getElementById('loginErrorDisplay');
                loginErrorMsg.style.display = 'block';
            }
        }
    }
}

/*
*  Informacje o pacjentach
*/
function getPatientsBCO(){//pobiera dane
    //Dane i nagłówki nie są podane jako parametry. Będą miały wartość null.
	theSAO.makeCall('GET', new getPatientsVCO(), 'Text', true, 'cmd=pat');
}
function getPatientsVCO(){//uaktualnia stronę po odebraniu danych
	this.notify = function(data){
		document.getElementById('content').innerHTML = data;
	}
}
/*
*  Informacje o pielęgniarzach
*/
function getNursesBCO(){
	theSAO.makeCall('GET', new getNursesVCO(), 'Text', true, 'cmd=nur');
}
function getNursesVCO(){//uaktualnia stronę po odebraniu danych
	this.notify = function(data){
		document.getElementById('content').innerHTML = data;
	}
}

/*
 *  Informacje o lekarzach
 */
function getDoctorsBCO(){
	theSAO.makeCall('GET', new getNursesVCO(), 'Text', true, 'cmd=doct');
}

/*
*  Informacje o wizytach pacjenta
*/
function getPatientVisitsBCO(target){
    //jeśli tabela z wizytami tego pacjenta nie została jeszcze pobrana, pobierz ją
    if(target.parentNode.getElementsByTagName('table')[0] == null){
        theSAO.makeCall('GET', new getPatientVisitsVCO(target), 'Text', true, 'cmd=pat_vis&num='+target.id);
    }
    //jeśli dane były już pobierane, wyświetl je ponownie
    else{
        //ponieważ nie jest generowane asynchroniczne żądanie pobrania danych które zwykle wywołuje VCO
	//należy VCO wywołać bezpośrednio
        //przekaż jako parametr informację o jakie dane chodzi
        var aVCO = new getPatientVisitsVCO(target);
        aVCO.notify(null);
    }
}
function getPatientVisitsVCO(target){//uaktualnia stronę po odebraniu danych
    this.target = target;
    
   	this.notify = function(data){
        if(data == null){
            //znajdź tabelę z wizytami
            var visitTable = this.target.parentNode.getElementsByTagName('table')[0];
            //sprawdź czy nie należy jej ukryć
            if(this.target.innerText == '-' || this.target.innerHTML =='-'){
                //jeśli tak zmień wyświetlany tekst (wersja IE i Firefox)
                this.target.innerHTML = this.target.innerText = '+';
                //ukryj tabelę
                visitTable.style.display = 'none';      
            }
            else{//jeśli tabela musi zostać wyświetlona
                //zmień wyświetlony tekst (wersja IE i Firefox)
                this.target.innerHTML = this.target.innerText = '-';
                //wyświetl tabelę
                visitTable.style.display = 'block';
            }
        }
        else{//jeśli tabela jeszcze nie istnieje, wstaw ją
            //zmień wyświetlony tekst (wersja IE i Firefox)
            this.target.innerHTML = this.target.innerText = '-';
            //wstaw tabelę z wizytami
            this.target.parentNode.innerHTML += data;
        }
	}
}

/*
*  Informacje  o wszystkich wizytach
*/
function getVisitsBCO(){
	theSAO.makeCall('GET', new getVisitsVCO(), 'Text', true, 'cmd=vis');
}
function getVisitsVCO(){//uaktualnia stronę po otrzymaniu danych
	this.notify = function(data){
		document.getElementById('content').innerHTML = data;
	}
}

/*
*  wyświetlenie powiązań pacjentów z pielęgniarzami
*/
function getPatientNurseAssignBCO(){
	theSAO.makeCall('GET', new getPatientNurseAssignVCO(), 'Text', true, 'cmd=ret_pat_nur');
}
//uaktualnia stronę po odebraniu danych oraz obsługuje mechanizm przeciągania i upuszczania
function getPatientNurseAssignVCO(){
	this.notify = function(data){
		
        var contentPane = document.getElementById('content');
        contentPane.innerHTML = data;
        //czyści stare lokalizacje z danych
        dropLocations = new Array();
        //zapisuje wszystkie lokalizacje nieuporządkowanych list
        calculateDropLocations(contentPane, 'ul');
        window.onresize = function(){
            calculateDropLocations(contentPane, 'ul');
        }
        //dodatkowa funkcja wywoływana przed standardową funkcją
        //rozpoczynającą przeciąganie
        startDraggingFunc  = function(event, aNode){
            //w tym momencie ta funkcja nic nie robi
        }
        //dodatkowa funkcja wywoływana po standardowej funkcji obsługującej
        //przeciąganie elementu
        draggingFunc = function(event, aNode){
            event = event || window.event;//jeśli event ma wartość null należy pobrać wartość z okna
            var aList = getDropLocation(event.clientX, event.clientY);
            var parent = aNode.parentNode;
            while(parent != null){
                if(aList == parent){
                    return;
                }
                parent = parent.parentNode
            }
            //Przeglądanie wszystkich list na które można upuszczać. Choć marnuje to dużo cykli
            //jeśli przeciąganie nie kończy się na żadnej z list, jest to niezbędne ponieważ
            //niektóre zdarzenia nie są przetwarzane jeśli do silnik JavaScript zostanie zapchany
            //zdarzeniami. Bardzo szybkie przeniesienie elementu może spowodować takie przeskoczenie
            //zdarzenia a to naprawi ewentualne problemy. 
            var listLength = dropLocations.length;
            for(var i = 0; i < listLength; i++){
                var aDropListLocation = dropLocations[i];
                aDropListLocation.node.style.border = "solid 1px";
            }
            if(aList){
                aList.style.border = "solid 3px";
            }
        }
        //dodatkowa funkcja do wywołania przed standardową funkcją obsługującą 
        //zakończenie przeciągania elementu
        stoppedDraggingFunc = function(event, aNode){
            event = event || window.event;//jeśli event ma wartość null należy pobrać wartość z okna
            aNode.style.top = "0px";
            aNode.style.left = "0px";
            
            aNode.origY = 0;
            aNode.origX = 0;
            var aList = getDropLocation(event.clientX, event.clientY);
            var parent = aNode.parentNode;
            while(parent != null){
                if(aList == parent){
                    return;
                }
                parent = parent.parentNode
            }
            if(aList){//element może być upuszczony poza listami
                aList.appendChild(aNode);
                //utwórz dwa obiekty do przenoszenia niezbędnych danych
                var mockEvent = new Object();
                var mockTarget = new Object();
                mockTarget.patientID = aNode.id;
                mockTarget.nurseID = aList.id;
                mockEvent.currentTarget = mockTarget;
                theController.dispatch('update_pat_nur', mockEvent);
            }
        }
        //zamień wszystkie elementy listy w elementy które można przenosić
        buildDraggables(contentPane, 'li', startDraggingFunc, draggingFunc, stoppedDraggingFunc); 
	}
}

/*
*  uaktualnienie powiązania pacjenta z pielęgniarzem
*/
function updatePatientNurseAssignBCO(target){
	theSAO.makeCall('POST', new updatePatientNurseAssignVCO(), 'Text', true, 'cmd=update_pat_nur&patID='+target.patientID +'&nurID=' + target.nurseID,null);
}

function updatePatientNurseAssignVCO(){//ponieważ błędy będą przesyłane w inny sposób
                                       //ta metoda notify będzie wywoływana jedynie po udanym
                                       //zapisaniu danych
	this.notify = function(data){
        //utwórz obiekt div umieszczony po prawej na górze strony do wyświetlania znikającego
        //napisu z informacją o poprawnym zapisaniu danych
        var aMessageDiv = document.getElementById('messageDiv');
        if(!aMessageDiv){
            aMessageDiv = document.createElement('div');
            aMessageDiv.id = 'messageDiv';
            aMessageDiv.style.height = '30px';
            aMessageDiv.style.width = '75px';
            aMessageDiv.style.position = 'absolute';
            aMessageDiv.style.top = '3px';
            document.getElementsByTagName('body')[0].appendChild(aMessageDiv);
        }
        aMessageDiv.innerHTML = 'Pacjent przypisany';
        setTimeout('document.getElementById("messageDiv").innerHTML=""',1500);
    }
}


/*
* Informacje o stanie magazynu
*/
function getInventoryBCO(){
    theSAO.makeCall('GET', new getInventoryVCO(), 'Text', true, 'cmd=cur_inv');
}
function getInventoryVCO(){
    this.notify = function(data){
		document.getElementById('content').innerHTML = data;
	}
}
/*
*  Informacje o stanie magazynu dostawcy
*/
function getSupplierInventoryBCO(){
    theSAO.makeCall('GET', new getSupplierInventoryVCO(), 'Text', true, 'cmd=sup_inv');
}
function getSupplierInventoryVCO(){
    this.notify = function(data){
		document.getElementById('content').innerHTML = data;
	}
}

/*
*  Wykres wartości magazynu
*/
function getInventoryChartBCO(){
    theSAO.makeCall('GET', new getInventoryChartVCO(), 'Text', true, 'cmd=inv_cost');
}
var aChart = null;//globalny wskaźnik wykresu
function getInventoryChartVCO(){
    this.notify = function(data){
        //wstaw HTML
        var HTML = '<h2>Wartość magazynu w dolarach</h2>';
        HTML += '<div style="width: 500px; border: solid 1px; padding: 20px;">';
        HTML += '<div id="chartContainer" style="width: 500px; height:300px;"></div>';
        HTML += '</div><input id="pie" type="button" value="Wykres kołowy" onclick="aChart.setType(this.id);aChart.show()">';
        HTML += '<input id="bar" type="button" value="Wykres słupkowy" onclick="aChart.setType(this.id);aChart.show()">';
       document.getElementById('content').innerHTML = HTML;
        //stwórz wykres
        var chartContainer = document.getElementById('chartContainer');
        var dataArray = data.split('_DeLiMiTeRsTrInG_');
        aChart = new SimplePlot(chartContainer, 'bar', 'Purple');
        aChart.addLabels(dataArray[0]);
        aChart.addStringDataSeries(dataArray[1], "Aktualna wartość magazynu");
        //wyświetl wykres
        aChart.show();
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/*
*  Logowanie
*/
function loginBCO(){
    //pobierz nazwę użytkownika oraz hasło i usuń wszystkie białe znaki
    //z początku i końca pobranych wartości
    var userName = trim(document.getElementById('unameField').value);
    var password = trim(document.getElementById('pwordField').value);
    //sprawdź czy ciągi znaków nie są puste
    if(userName == '' || password == ''){
        //jeśli jeden z ciągów jest pusty wyświetl komunikat o błędzie
        var badLogin = new showBadLoginVCO();
        badLogin.notify(null);
    }
    else{
        //jeśli nazwa użytkownika i hasło wyglądają poprawnie 
        //wyślij do serwera żądanie zalogowania
        theSAO.makeCall('POST', new loginVCO(), 'Text', true, 'cmd=login&name='+userName+'&pass='+password);
    }
}
function loginVCO(){
    this.notify = function(data){
        //jeśli nie wystąpił błąd upewnij się że komunikat 
        //o niepoprawnej nazwie użytkownika lub haśle
        //jest ukryty. Mógł być on wyświetlony podczas poprzedniej
        //próby logowania.
        var loginErrorMsg = document.getElementById('loginErrorDisplay');
        loginErrorMsg.style.display = 'none';
        //zapisz stan loggedIn w obiekcie sesji
        session.addAttribute('loggedIn', true);
        //usuń wszystkie białe znaki z początku i końca
        data = trim(data);
        //jeśli sesja była wcześniej zapisana w bazie danych pobierz ją
        //w postaci par klucz wartość
        if(data.length > 0){
            //przetwórz ciąg JSON na obiekt JavaScript
            var storedSessionMap = data.parseJSON();
            //jeśli zapisana sesja zawiera dane o tym którą podstronę należy wyświetlić
            //przejdź do tej podstrony
            if(storedSessionMap['homeSubPage'] && storedSessionMap['homeSubPage'] != undefined){
                updateURL(storedSessionMap['homeSubPage'], null);
            }
            else{
                //w bazie nie ma zapisanej takiej informacji więc należy wyświetlić domyślny komunikat
                document.getElementById('content').innerHTML = '<h3>Witamy</h3>';
                updateURL("default", null);
            }
            var mashupDescriptorArray = storedSessionMap['mashupDesc'];
            session.addAttribute('mashupDesc', mashupDescriptorArray);
        }
        else{
            //w bazie danych nie ma zapisanej sesji więc należy wyświetlić domyślny komunikat
            document.getElementById('content').innerHTML = '<h3>Witamy</h3>';
            updateURL("default", null);
        }
	}
}
function storeSessionBCO(){
    //usuń poniższą linię przed udostępnieniem aplikacji 
    //ponieważ jest ona aby czytelnik mógł zobaczyć jak wygląda
    //obiekt sesji po przetworzeniu na ciąg JSON
    alert(session.toJSONString());
    //zapisz ciąg opisujący sesję na serwerze bez użycia VCO
    theSAO.makeCall('POST', null, 'Text', true, 'cmd=store&sessDef='+session.toJSONString());
}

function mashupBCO(){
    //nie jest potrzebne połączenie z serwerem ponieważ
    //informacje o sesji zostały pobrane przy logowaniu
    var mashupDescriptorArray = session.getAttribute('mashupDesc');
    var aVCO = new mashupVCO();
    aVCO.notify(mashupDescriptorArray);
}
function mashupVCO(){
    this.notify = function(data){
        var displayString  = "<div>";
        displayString += "<input type='button' value='Dodaj kolejną stronę' onclick='requestNewMashFrame(\"mashupContainer\")' />";
        displayString += "<input type='button' value='Zapisz zmiany w mashupie' onclick='saveMashupBCO()' />";
        displayString += "<div id='mashupContainer' style='height: 4000px; width: 2000px;'></div></div>";
        document.getElementById('content').innerHTML = displayString;
        
        MashFrame.mashCount = 0;
        MashFrame.mashArray = new Array();
        if(data != null){
            var numFrames = data.length;
            for(var i = 0; i < numFrames; i++){
                var aDescription = data[i];
                new MashFrame(aDescription.URL, 'mashupContainer', aDescription.left, aDescription.top, 
                             aDescription.width, aDescription.height, aDescription.scrollDown, aDescription.scrollRight);
            }
        }
    }
}

function saveMashupBCO(){
    //utwórz lub zastąb atrybut nowym
    session.addAttribute('mashupDesc', getMashupDescriptor());
    //umieść ciąg opisujący sesję na serwerze bez korzystania z VCO
    theSAO.makeCall('POST', null, 'Text', true, 'cmd=store&sessDef='+session.toJSONString());
}

function getReportCreationBCO(){
    //wyczyść sesję by zacząć tworzenie nowego raportu
    session.removeAttribute('currentReport');
    session.removeAttribute('patientForReport');
    session.removeAttribute('doctorForReport');
    theSAO.makeCall('GET', new getReportCreationVCO(), 'Text', true, 'cmd=crRepDef');
}
function getReportCreationVCO(){
    this.notify = function(data){
        //wyczyść div z treścią podstrony
        var content = document.getElementById('content');
        content.innerHTML = "";
        //sposób na odnalezienie wyświetlanych pól wprowadzania danych w Safari 
        var reportDisplayContent = document.getElementById('reportHolder').innerHTML;
        //usuń wszystkie wystąpienia ciągu 'Stored'
        reportDisplayContent = reportDisplayContent.replace(/Stored/g,'');
        //wyświetl ekran logowania
        document.getElementById('content').innerHTML = reportDisplayContent;
        //utwórz obiekty Option w odpowiednich obiektach Selection
		var dataArray = data.parseJSON();
        var doctorArray = dataArray[0];
        var patientArray = dataArray[1];
        var fieldArray = dataArray[2];
        
        var doctorSelect = document.getElementById('doctorSelection');
        var numRecords = doctorArray.length;
        for(var i = 0; i < numRecords; i++){
            var aDoctorData = doctorArray[i];
            var aDoctor = document.createElement('option');
            aDoctor.value = aDoctorData[0];
            aDoctor.innerHTML = aDoctorData[2]+", "+aDoctorData[1];
            doctorSelect.appendChild(aDoctor);
        }
        
        var patientSelect = document.getElementById('patientSelection');
        var numRecords = patientArray.length;
        for(var i = 0; i < numRecords; i++){
            var aPatientData = patientArray[i];
            var aPatient = document.createElement('option');
            aPatient.value = aPatientData[0];
            aPatient.innerHTML = aPatientData[2]+", "+aPatientData[1];
            patientSelect.appendChild(aPatient);
        }
        
        var statisticSelect = document.getElementById('statisticSelection');
        var numRecords = fieldArray.length;
        for(var i = 0; i < numRecords; i++){
            var aStat = document.createElement('option');
            aStat.value = fieldArray[i];
            aStat.innerHTML = fieldArray[i];
            statisticSelect.appendChild(aStat);
        }
    }
}

function getReportPreviewBCO(){
    //wyczyść div z ostrzeżeniem
    var warningDiv = document.getElementById('reportWarningDiv');
    warningDiv.innerHTML = '';
    //Wywołanie statyczne
    //zmienna requirements będzie zawierałą null jeśli walidacja się nie powiedzie
    var requirements = getReportPreviewBCO.getRequirements();
    if(requirements == null){
        return;
    }
    //utwórz parametr URL stats
    var selectedStats = "";
    var statsArray = requirements.stats;
    var numStats = statsArray.length;
    for(var i = 0; i < numStats; i++){
        selectedStats += statsArray[i];
        if(i < numStats -1){
            selectedStats += ';';
        }
    }
    theSAO.makeCall('GET', new getReportPreviewVCO(), 'Text', true, 'cmd=prevRep&patient='+requirements.patientID+'&stats='+selectedStats+'&from='+requirements.from+'&to='+requirements.to);
}

//statyczna metoda obiektu getReportPreviewBCO
//sprawdza poprawność wprowadzonych danych i zwraca je jeśli są poprawne
//jeśli nie są poprawne zwraca null
getReportPreviewBCO.getRequirements = function(){
    var requirements = new Object();
    //pobierz ID wybranego pacjenta i wszystkie wybrane dane do raportu
    var patientSelector = document.getElementById('patientSelection');
    var selectedPatientIndex = patientSelector.selectedIndex;
    var warningDiv = document.getElementById('reportWarningDiv');
    //jeśli nie wybrano pacjenta
    if(selectedPatientIndex == -1){
        warningDiv.innerHTML = 'Aby można było wyświetlić dane raportu należy wybrac pacjenta. Proszę wybrać pacjenta.';
        return null;
    }
    var patientID = patientSelector[selectedPatientIndex].value;
    requirements.patientID = patientID;
    //ponieważ element HTML zwróci jedynie pierwszy wybrany element
    //należy odpytywać go w pętli do momentu gdy nie będzie miał nic
    //zaznaczonego po odebraniu wszystkich wybranych elementów. 
    //Jest to podobne do zdejmowania ze stosu. Następnie zaznaczenia 
    //muszą być przywrócone tak by użytkownik mógł je zmodyfikować bez
    //wybierania wszystkiego ponownie.
    var selectedIndexArray = new Array();
    var selectedStatsArray = new Array();
    var statSelector = document.getElementById('statisticSelection');
    for(var selectedIndex = statSelector.selectedIndex; selectedIndex != -1; selectedIndex = statSelector.selectedIndex){
        //zapisz które opcje były wybrane
        selectedIndexArray.push(selectedIndex);
        //zapisz wartość wybranej opcji
        selectedStatsArray.push(statSelector.options[selectedIndex].value);
        //wyłącz zaznaczenie tak by można było pobrać kolejne
        statSelector.options[selectedIndex].selected = false;
    }
    var numSelectedIndex = selectedIndexArray.length;
    if(numSelectedIndex == 0){
        warningDiv.innerHTML = 'Raport musi prezentować przynajmniej jedną informację. Proszę wybrać jedną lub więcej.';
        return null;
    }
    //przywróć zaznaczenia użytkownika
    for(var i = 0; i < numSelectedIndex; i++){
        var selectedIndex = selectedIndexArray[i];
        statSelector.options[selectedIndex].selected = true;
    }
    requirements.stats = selectedStatsArray;
    
    //ustaw domyślne wartości w przeszłości i przyszłości
    var fromDate = document.getElementById('fromDate').value;
    if(!fromDate){
        fromDate = '01-01-1900';
    }
    var toDate = document.getElementById('toDate').value;
    if(!toDate){
        toDate = '01-01-2100';
    }
    var errorMessage = dateValidation(fromDate, 'from');
    if(errorMessage != null){
        warningDiv.innerHTML = errorMessage;
        return;
    }
    errorMessage = dateValidation(fromDate, 'to');
    if(errorMessage != null){
        warningDiv.innerHTML = errorMessage;
        return;
    }
    //przypisz daty od i do
    requirements.from = fromDate;
    requirements.to = toDate;
    return requirements;
}

function getReportPreviewVCO(){
    this.notify = function(data){
		document.getElementById('reportPreviewDiv').innerHTML = data;
    }
}

function storeReportDefBCO(){
    var currentReportID = session.getAttribute('currentReport');
    var requirements = getReportPreviewBCO.getRequirements();
    if(requirements == null){
        return;
    }
    //jeśli zmieniony identyfikator pacjenta rozpocznij nowy raport
    if(session.getAttribute('patientForReport') != requirements.patientID){
        currentReportID = null;
    }
    session.addAttribute('patientForReport', requirements.patientID);
    //sprawdź i pobierz wybór lekarza
    var doctorSelector = document.getElementById('doctorSelection');
    var selectedIndex = doctorSelector.selectedIndex;
    if(selectedIndex == -1){
        document.getElementById('reportWarningDiv').innerHTML = 'W raporcie musi być wybrany lekarz który otrzyma raport. Proszę wybrać jednego z lekarzy.';
        return;
    }
    var doctorID = doctorSelector.options[selectedIndex].value;
    //jeśli zmieniono lekarza rozpocznij nowy raport
    if(session.getAttribute('doctorForReport') != doctorID){
        currentReportID = null;
    }
    session.addAttribute('doctorForReport', doctorID);
    var parameters = 'cmd=strRepDef&patient='+requirements.patientID+'&stats='+requirements.stats+'&from='+requirements.from+'&to='+requirements.to+'&recip='+doctorID;
    if(currentReportID != null){
        parameters += '&reportID='+currentReportID;
    }
    theSAO.makeCall('POST', new storeReportDefVCO(), 'Text', true, parameters);
}

function storeReportDefVCO(){
    this.notify = function(data){
        data = trim(data);
        if(session.getAttribute('currentReport') == data){
            document.getElementById('reportWarningDiv').innerHTML = 'Raport zmodyfikowany.';
        }
        else{
            document.getElementById('reportWarningDiv').innerHTML = 'Raport zapisany.';
        }
        session.addAttribute('currentReport', data);
    }
}

function getReportListBCO(){
    theSAO.makeCall('GET', new getReportListVCO(), 'Text', true, 'cmd=viewAllRepDef');
    
}
function getReportListVCO(){
    this.notify = function(data){
        data = trim(data).parseJSON();
        var reportListString = '<h2>Lista raportów</h2><div id="reportWarningDiv"></div><table id="reportListTable" border="1">';
        reportListString += '<tr><th>Data</th><th>Pacjent</th><th>Oglądany</th><th></th></tr>';
        var numReports = data.length;
        for(var i = 0; i < numReports; i++){
            var aReport = data[i];
            reportListString += '<tr><td>'+aReport[1]+'</td><td><span'
                +' onclick="session.addAttribute(\'viewedReport\',\''+aReport[0]+'\');'
                +' updateURL(\'vw_rep\', null); ">'
                + aReport[3] + ' '+aReport[2]+'</span></td>'
                + '<td><input id="rep_checkbox'+i+'" type="checkbox" disabled="true"';
            //pole powinno zawierać znacznik czasu zawierający datę i czas 
            //pierwszego odczytania raportu lub ciąg znaków zawierający 'false'
            if(aReport[4].length > 5){
                reportListString += 'checked="'+aReport[4]+'"';
            }
            reportListString += '/></td><td><input type="button" value="Usuń raport" onclick = "'
                +'session.addAttribute(\'viewedReport\',\''+aReport[0]
                +'\'); theController.dispatch(\'rm_rep\', null); " /></td></tr>';
        }
        reportListString += '</table>';
        document.getElementById('content').innerHTML = reportListString;
    }
}
function getReportBCO(){
    var reportID = session.getAttribute('viewedReport');
    theSAO.makeCall('POST', new getReportVCO(), 'Text', true, 'cmd=viewRepDef&report='+session.getAttribute('viewedReport'));
    session.removeAttribute('viewedReport');
}
function getReportVCO(){
    this.notify = function(data){
        document.getElementById('content').innerHTML =data;
    }
}
function removeReportDefBCO(){
    var reportID = session.getAttribute('viewedReport');
    theSAO.makeCall('POST', new getReportListVCO(), 'Text', true, 'cmd=rmvRepDef&report='+session.getAttribute('viewedReport'));
}

function dateValidation(aDate, dateName){
    aDate = trim(aDate);
    //domyślna wartość jeśli nie ma błędu
    var errorMessage = null;
    //upewnij się że data jest w formacie
    // 2 cyfry, minus, 2 cyfry, minus, 4 cyfry
    var dateChecker = /\d{2}-\d{2}-\d{4}/;
    if(!dateChecker.exec(aDate)){
        errorMessage = 'Podana data '+dateName+' musi być w formacie dd-mm-rrrr.  Proszę poprawić.';
    }
    var dateArray = aDate.split('-');
    //sprawdź czy rok jest przestępny
    //sprawdzając resztę z dzielenia przez 4
    var isLeapYear = dateArray%4 == 0;
    //sprawdź czy miesiąc jest z zakresu 01 - 12
    if(dateArray[1]*1 > 12 || dateArray[1]*1 == 0){
        errorMessage = 'W podanej dacie '+dateName+' miesiąc musi być z zakresu 01-12. Proszę poprawić.';
    }
    //sprawdzenie poprawności dnia w miesiącu jest podzielone aby łatwiej 
    //było zrozumieć. W kodzie produkcyjnym należy to połączyć w jedno wyrażenie
    //w taki sposób by komunikat był zapisany tylko raz.
    //
    //sprawdź czy dzień nie jest równy zero
    if(dateArray[0]*1 == 0){
        errorMessage = 'W podanej dacie '+dateName+' dzień '+dateArray[0]+' nie jest poprawny. Proszę poprawić.';
    }
    //w kwietniu, czerwcu, wrześniu i listopadzie 
    //sprawdź czy dzień nie jest większy niż 30
    else if((dateArray[1]*1 == 9 || dateArray[1]*1 == 4 || dateArray[1]*1 == 6 || dateArray[1]*1 == 11) && dateArray[0]*1 > 30){
        alert(1);
        errorMessage = 'W podanej dacie '+dateName+' dzień '+dateArray[0]+' nie jest poprawny. Proszę poprawić.';
    }
    else if(isLeapYear && dateArray[1]*1 == 2 && dateArray[0]*2 > 29){
        alert(2);
        errorMessage = 'W podanej dacie '+dateName+' dzień '+dateArray[0]+' nie jest poprawny. Proszę poprawić.';
    }
    else if(dateArray[1]*1 == 2 && dateArray[0]*2 > 28){
        alert(3);
        errorMessage = 'W podanej dacie '+dateName+' dzień '+dateArray[0]+' nie jest poprawny. Proszę poprawić.';
    }
    else if(dateArray[0]*1 > 31){
        alert(4);
        errorMessage = 'W podanej dacie '+dateName+' dzień '+dateArray[0]+' nie jest poprawny. Proszę poprawić.';
    }
    if(dateArray[2]*1 < 1900){
        errorMessage = 'W podanej dacie '+dateName+' dzień '+dateArray[0]+' nie jest poprawny. Proszę poprawić.';
    }
    
    return errorMessage;
}
function resetReportDefBCO(){
    
    session.removeAttribute('currentReport');
    session.removeAttribute('patientForReport');
    session.removeAttribute('doctorForReport');
    
    var patientSelector = document.getElementById('patientSelection');
    var selectedPatientIndex = patientSelector.selectedIndex;
    var warningDiv = document.getElementById('reportWarningDiv');
    //jeśli pacjent jest wybrany, usuń zaznaczenie
    if(selectedPatientIndex != -1){
        patientSelector.options[selectedPatientIndex].selected = false;
    }
    var statSelector = document.getElementById('statisticSelection');
    for(var selectedIndex = statSelector.selectedIndex; selectedIndex != -1; selectedIndex = statSelector.selectedIndex){
        //usuń zaznaczenie
        statSelector.options[selectedIndex].selected = false;
    }
    var doctorSelector = document.getElementById('doctorSelection');
    var selectedDoctorIndex = doctorSelector.selectedIndex;
    if(selectedDoctorIndex != -1){
        doctorSelector.options[selectedDoctorIndex].selected = false;
    }
    document.getElementById('fromDate').value = '31-12-1999';
    document.getElementById('toDate').value = '';
    
}
