/**
*Create a new Session instance. 
* @class The purpose the Session class is to store data in a key value pair set.  This 
* session class is for data storage only and contains no intelegence.  Tracking of session 
* data on the client can be extreamly valuable since it need not be transmitted to 
* nor retrieved from the server thus increasing security and decreasing response times.  
* While this functionallity is built into every JavaScript object, this class is provided 
* for consistancy and to show how to use the value of a variant as the name of a class attribute.  
* This is possible since every JavaScript Object is an associative array.
* @constructor
* @return  a new Session
*/

function Session(){
	this.addAttribute = addAttribute;
	this.getAttribute = getAttribute;
	this.removeAttribute = removeAttribute;
	this.hasAttribute = hasAttribute;
}

/**
* adds a key-value pair to the session
*@param attributeKey the key to be used for storage and retrieval of the value. 
*@param attributeValue the value to be stored for retrieval by the use of the key
* @return {void}nothing
*/
function addAttribute(attributeKey, attributeValue){
	if(attributeKey){
		this[attributeKey] = attributeValue;
	}
}

/**
* retrieves the value associated with the designated key
*@param attributeKey the key to be used to retrieve the attribute
* @return the value associated with the key or null if no such key exists
*/

function getAttribute(attributeKey){
	if(attributeKey && this.hasOwnProperty(attributeKey)){
		return this[attributeKey];
	}
}

/**
* nullifies the key-value pair
*@param attributeKey the key of the key-value pair to be nullified
* @return {void}nothing
*/

function removeAttribute(attributeKey){
	if(attributeKey && this.hasOwnProperty(attributeKey)){
		this[attributeKey] = null;
	}
}

/**
* indicates if the key exists
*@param attributeKey the key to be found if it exists
* @return true if the key exists, false if it does not
*/

function hasAttribute(attributeKey){
	if(attributeKey){
		if(this[attributeKey]){
			return true;
		}
	}
	return false;
}
//create a global session object
var session = new Session();