<?php
/*
*  the model
*/
class DBModel{
	private $userName;
	private $password;
	private $dbURL;
	function __construct(){
		$this->userName = "app";
		$this->password = "badpass";
		$this->dbURL = "//localhost/XE";
	}
    function getData($sql, $fieldValueArray)
	{
		$conn = oci_connect($this->userName,$this->password,$this->dbURL);
		$stmt = oci_parse($conn,$sql);
//        $conn = oci_connect($this->userName,$this->password,$this->dbURL);
//		$stmt = oci_parse($conn,$sql);
        //if a get is being done by binding variables(using prepared statements)
        if($fieldValueArray != null){
            $arrayLength = count($fieldValueArray);
            for($i = 0; $i < $arrayLength; $i++){
                oci_bind_by_name($stmt, $fieldValueArray[$i][0], $fieldValueArray[$i][1], -1, $fieldValueArray[$i][2]);
            }
        }
        oci_execute($stmt);
		$rowCnt = oci_fetch_all($stmt, $results);
        //free and close the connection as soon as possible to free it up for further use
		oci_free_statement($stmt);
		oci_close($conn);
		return $results;
	}
    function setData($sql, $fieldValueArray){
		$conn = oci_connect($this->userName,$this->password,$this->dbURL);
		$stmt = oci_parse($conn,$sql);
        //if a get is being done by binding variables(using prepared statements)
        if($fieldValueArray != null){
            $arrayLength = count($fieldValueArray);
            $lobArray = array();
            for($i = 0; $i < $arrayLength; $i++){
                //handle CLOB and BLOB types
                if($fieldValueArray[$i][2] == SQLT_CLOB || $fieldValueArray[$i][2] == SQLT_BLOB){
                   $lobArray[] = $this->prepareLob($conn, $stmt, $fieldValueArray[$i] , $lobArray);
                }
                //handle other types
                else{
                    oci_bind_by_name($stmt, $fieldValueArray[$i][0], $fieldValueArray[$i][1], -1, $fieldValueArray[$i][2]);
                }
            }
        }
        //OCI_DEFAULT must be included as the second parameter
        //of the oci_execute function or an error will be thrown
        //by the save method of the LOB object 
        //that states that binding is not allowed across transactions.
        //If OCI_DEFAULT is not included the oci_execute function
        //will default to doing an auto commit instead of wating
        //for the call to oci_commit after the LOB has been updated.
        //In other words the OCI_DEFAULT parameter causes non-default
        //behavior in the oci_execute function.
        if(oci_execute($stmt, OCI_DEFAULT)){
            $lobArrayLength = count($lobArray);
            //save the lob information into the database LOB objects
            for($i = 0; $i < $lobArrayLength; $i++){
                $lobArray[$i][0]->save($lobArray[$i][1]);
            }
            //and commit the changes
            $result = oci_commit($conn);
        }
        oci_close($conn);
        return $result;
    }
    function prepareLob($conn, $stmt, $field, $lobArray){
        $aLob = oci_new_descriptor($conn, OCI_D_LOB);
        //define a variable name to map the the clob
        $success =  oci_define_by_name($stmt, $field[0], $aLob, $field[2]);
        //bind the php variable to the OCI clob variable name
        $success = oci_bind_by_name($stmt, $field[0], $aLob, -1, $field[2]);
        //return an array of the lob and the value to be stored in it
        //once the execute method has been called
        return array($aLob, $field[1]);
    }
}
?> 
