<?php
require_once 'XML/RPC.php';
class XMLRPCModel{
	function __construct(){
	}
    //wystarczy tylko jedna funkcja ponieważ zarówno pobieranie jak i zapisywanie wygląda tak samo
	function sendMessage($messageString, $URL, $serverPage, $portNum, $parameters){
        //Utworzenie XML_RPC_Message do wysłania do XML_RPC_Server
        //przygotuj wszystkie parametry do wysłania
        //Ponieważ komunikujemy się mając serwer z PHP na drugim końcu będziemy traktować wszystkie 
        //parametry jak ciągi znaków. Jeśli nie był by to PHP potrzebne byłyby typy parametrów i należałoby
        //je przekazywać w tablicy wartości parametrów.

        $parameterValueArray = null;
        if($parameters != null){
            $parameterValueArray = array();
            $numParameters = sizeof($parameters);
            for($i = 0; $i < $numParameters; $i++){
                $parameterValueArray[] = new XML_RPC_Value($parameters[$i], "string");
            }
        }
        $msg = new XML_RPC_Message($messageString, $parameterValueArray);
        //utwórz obiekt XML_RPC_Client do obsługi całej komunikacji z serwerem
        $client = new XML_RPC_Client($serverPage, $URL, $portNum);
        //odeślij komunikat i zwróć dane udostępniane przez usługę
        //Wywołanie synchroniczne
        $rpcData = $client->send($msg);
        //Jeśli nie było błędu zwróć XML_RPC_Response
        //rpcData będzie miało wartość null jeśli przekazany został zły messageString
        if($rpcData != null && !$rpcData->faultCode()){
            return $rpcData;
        }
        return null;
	}
}
?>
