<?php
    // Zwróć udaną próbę połączenia z bazą danych
    if ($c = @oci_connect("app", "badpass", "//localhost/XE"))
    {
        // Zadeklaruj zmienne wejściowe
        (isset($_GET['begin'])) ? $t_start = (int) $_GET['begin'] : $t_start = 1787;
        (isset($_GET['end'])) ? $t_end = (int) $_GET['end'] : $t_end = (int) date("Y",time());
        (isset($_GET['country'])) ? $country = $_GET['country'] : $country = "USA";
        // Deklaracja polecenia PL/SQL
        $stmt = "BEGIN
                    world_leaders.get_presidents(:term_start
                                                ,:term_end
                                                ,:country
                                                ,:p_id
                                                ,:p_name
                                                ,:p_tenure
                                                ,:p_party);
                END;";
        // Usuń znaki specjalne by uniknąć błędów ORA-06550 i PLS-00103
        $stmt = strip_special_characters($stmt);

        // Przetwórz wyrażenie w połączeniu
        $s = oci_parse($c,$stmt);

        $r_president_id = "";
        $r_president_name = "";
        $r_tenure = "";
        $r_party = "";

        // Połącz zmienne PHP ze zmiennymi wejściowymi OCI (w trybie in)
        oci_bind_by_name($s,':term_start',$t_start);
        oci_bind_by_name($s,':term_end',$t_end);
        oci_bind_by_name($s,':country',$country);

        // Połącz zmienne PHP ze zmiennymi wyjściowymi OCI (w trybie in/out)
        oci_bind_array_by_name($s,':p_id',$r_president_id,100,38,SQLT_INT);
        oci_bind_array_by_name($s,':p_name',$r_president_name,100,10,SQLT_STR);
        oci_bind_array_by_name($s,':p_tenure',$r_tenure,100,10,SQLT_STR);
        oci_bind_array_by_name($s,':p_party',$r_party,100,24,SQLT_STR);

        // Wykonaj polecenie PL/SQL
        if (oci_execute($s))
        {
            // Zadeklaruj zmienną i rozpocznij tabelę HTML
            $out = '<table border="1" cellpadding="3" cellspacing="0">';
            $out .= '<tr>';
            $out .= '<td class="e">#</td>';
            $out .= '<td class="e">Nazwisko prezydenta</td>';
            $out .= '<td class="e">Urzędowanie</td>';
            $out .= '<td class="e">Partia</td>';
            $out .= '</tr>';
            // Wczytaj tablice
            for ($i = 0;$i < count($r_president_id);$i++)
            {
                $out .= '<tr>';
                $out .= '<td class="v">'.$r_president_id[$i].'</td>';
                $out .= '<td class="v">'.$r_president_name[$i].'</td>';
                $out .= '<td class="v">'.$r_tenure[$i].'</td>';
                $out .= '<td class="v">'.$r_party[$i].'</td>';
                $out .= '</tr>';
            }
            // Zakończ tabelę HTML
            $out .= '</table>';
        }
        // Wyświetl tabelę
        print $out;
        // Odłącz od bazy danych
        oci_close($c);
    }
    else
    {
        // Pobierz błąd OCI i odpowiednio sformatuj
        $errorMessage = oci_error();
        print htmlentities($errorMessage['message'])."<br />";
    }
    // Usuń znaki specjalne takie jak znak nowej linii i tabulacje
    function strip_special_characters($str)
    {
        $out = "";
        for ($i = 0;$i < strlen($str);$i++)
            if ((ord($str[$i]) != 9) && (ord($str[$i]) != 10) && (ord($str[$i]) != 13))
                $out .= $str[$i];
        return $out;
    }
?>
