get utl1
CREATE OR REPLACE PROCEDURE wczytaj_dane_rodzinne (
 nazwa_pliku_danych  varchar2,
 nazwa_katalogu      varchar2,
 przetworzonych_wierszy OUT number,
 kod_powrotny OUT number)
IS
 uchwyt_pliku  UTL_FILE.FILE_TYPE;  -- uchwyt zwykego pliku systemu operacyjnego
 bufor_wiersza     varchar2(100);   -- wiersz odczytany z pliku
 l_tekst           varchar2(1000);
 l_nowy_tekst      varchar2(1000);
 l_pominiety_tekst varchar2(1000);
 l_separator       varchar2(1) :='|';  -- separator pol
 l_licznik         number := 0;
 l_poz             number := 1;
 l_nowa_poz        number := 0;
 l_koniec          number := 1000;
 l_nowy_koniec     number := 0;
 l_poz_odczytu     number := 0;
 l_tabela_rodz     rodzina%ROWTYPE;
 BEGIN
  dbms_output.put_line('Start');
  -- Otworz plik do zapisu i pobierz jego uchwyt
  dbms_output.put_line('Otwieram plik');
  uchwyt_pliku := UTL_FILE.FOPEN(nazwa_katalogu, nazwa_pliku_danych, 'R');
  dbms_output.put_line('Plik otwarty');
  BEGIN
   LOOP
   -- wczytaj wiersz pliku
   utl_file.get_line (uchwyt_pliku, l_tekst);
   l_poz_odczytu := l_poz_odczytu + 1;
   -- pole Imie
   l_poz := instr(l_tekst, l_separator);
   l_nowy_tekst := substr(l_tekst, l_poz+1);
   l_nowa_poz := instr(l_nowy_tekst, l_separator);
   l_tabela_rodz.imie := substr(l_tekst, 1, l_poz-1);
   l_tekst := l_nowy_tekst;
   -- Nazwisko
   l_poz := instr(l_tekst, l_separator);
   l_nowy_tekst := substr(l_tekst, l_poz+1);
   l_nowa_poz := instr(l_nowy_tekst, l_separator);
   l_tabela_rodz.nazwisko := substr(l_tekst, 1, l_poz-1);
   l_tekst := l_nowy_tekst;
   -- Pokrewienstwo
   l_poz := length(l_tekst)+1;
   l_tabela_rodz.pokrewienstwo := substr(l_tekst, 1, l_poz-1);
   insert into RODZINA (
    imie,
    nazwisko,
    pokrewienstwo
   )
   values (
    l_tabela_rodz.imie,
    l_tabela_rodz.nazwisko,
    l_tabela_rodz.pokrewienstwo);
    l_licznik := l_licznik + 1;
   END LOOP; 
  przetworzonych_wierszy := l_licznik;
  commit;
  kod_powrotny := 0;
  EXCEPTION
   WHEN NO_DATA_FOUND THEN
    null;
 END; 
  -- Zamknij plik
  UTL_FILE.FCLOSE(uchwyt_pliku);
  EXCEPTION
  -- Obsluga bledow zglaszanych przez utl_file
   WHEN NO_DATA_FOUND THEN
    DBMS_OUTPUT.PUT_LINE('brak_danych');
    UTL_FILE.FCLOSE(uchwyt_pliku);
    kod_powrotny := SQLCODE;
   WHEN UTL_FILE.INVALID_PATH THEN
    DBMS_OUTPUT.PUT_LINE('UTL_FILE.INVALID_PATH');
    UTL_FILE.FCLOSE(uchwyt_pliku);
    kod_powrotny := SQLCODE;
   WHEN UTL_FILE.READ_ERROR THEN
    DBMS_OUTPUT.PUT_LINE(' UTL_FILE.READ_ERROR');
    UTL_FILE.FCLOSE(uchwyt_pliku);
    kod_powrotny := SQLCODE;
   WHEN UTL_FILE.WRITE_ERROR THEN
    DBMS_OUTPUT.PUT_LINE('UTL_FILE.WRITE_ERROR');
    UTL_FILE.FCLOSE(uchwyt_pliku);
    kod_powrotny := SQLCODE;
   WHEN OTHERS THEN
    DBMS_OUTPUT.PUT_LINE('BLAD:'||SQLERRM||'.');
    UTL_FILE.FCLOSE(uchwyt_pliku);
    kod_powrotny := SQLCODE;
END;
/
