CREATE OR REPLACE PROCEDURE pob_przych_stat
(we_nazwa_pliku     VARCHAR2,
 we_kat_pliku       VARCHAR2,
 we_system_zrod     VARCHAR2)
IS
      pr_obsl_pliku UTL_FILE.FILE_TYPE; -- uchwyt pliku systemowego
      l_tekst           VARCHAR2(1000);
      l_data_pocz       VARCHAR2(10);
      l_godz_pocz       VARCHAR2(6);
      l_odczyt_kb       NUMBER;
      l_nazwa_str_www   VARCHAR2(1000);
BEGIN
      -- funkcja otwiera plik w trybie do odczytu i zwraca uchwyt pliku do zmiennej pr_obsl_pliku

      pr_obsl_pliku := UTL_FILE.FOPEN('BCANDID', we_nazwa_pliku, 'R');

  BEGIN
    LOOP
      utl_file.get_line (pr_obsl_pliku, l_tekst);
      l_data_pocz     := substr(l_tekst,1,10);
      l_godz_pocz     := substr(l_tekst,11,6);
      l_odczyt_kb     := substr(l_tekst,17,10);
      l_nazwa_str_www := substr(l_tekst,27,1000);
                           insert into stat_dost_uzytk
                          (data_pocz, godz_pocz, odczyt_kb, str_www)
                          values
                          (l_data_pocz, l_godz_pocz, l_odczyt_kb, l_nazwa_str_www);
                      commit;
    END LOOP;
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
        null;  -- Juz po wszystkim, nie ma wiecej danych
  END;
  UTL_FILE.FCLOSE(pr_obsl_pliku);  -- zamykanie pliku danych
  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      DBMS_OUTPUT.PUT_LINE('no_data_found');
      UTL_FILE.FCLOSE(pr_obsl_pliku);
    WHEN UTL_FILE.INVALID_PATH THEN
      DBMS_OUTPUT.PUT_LINE('UTL_FILE.INVALID_PATH');
      UTL_FILE.FCLOSE(pr_obsl_pliku);
    WHEN UTL_FILE.READ_ERROR THEN
      DBMS_OUTPUT.PUT_LINE(' UTL_FILE.READ_ERROR');
      UTL_FILE.FCLOSE(pr_obsl_pliku);
    WHEN OTHERS THEN
      DBMS_OUTPUT.PUT_LINE('Blad'||SQLERRM||'.');
      UTL_FILE.FCLOSE(pr_obsl_pliku);
END;
/
