CREATE OR REPLACE TRIGGER wyzw_zwierzaki_gat_zwierzaka
      BEFORE
      DELETE OR INSERT OR UPDATE
      ON zwierzaki
      FOR EACH ROW
BEGIN
   if INSERTING then
       insert into dziennik
                  (id_dzien, tabela_dzien, dml_dzien,
                      id_klucza_dzien, nazwa_uzytk_dzien , data_dzien)
              values
                  (kol_id_dzien.nextval,'DZIENNIK','INSERT',
                      :new.id_zwierzaka, user , sysdate);
   elsif DELETING then
          insert into dziennik
                  (id_dzien, tabela_dzien, dml_dzien,
                      id_klucza_dzien, nazwa_uzytk_dzien , data_dzien)
                values
                  (kol_id_dzien.nextval,'DZIENNIK','DELETE',
                      :old.id_zwierzaka, user , sysdate);
   else
            insert into dziennik
                  (id_dzien, tabela_dzien, dml_dzien,
                      id_klucza_dzien, nazwa_uzytk_dzien , data_dzien)
                     values
                  (kol_id_dzien.nextval,'DZIENNIK','UPDATE',
                      :old.id_zwierzaka, user , sysdate);
   end if;


EXCEPTION
   WHEN others THEN
       raise_application_error(-20000,'BLAD wyzw_zwierzaki_gat_zwierzaka: '
                               ||SQLERRM);

END wyzw_zwierzaki_gat_zwierzaka;
/
