CREATE MATERIALIZED VIEW LOG ON dzial
  WITH PRIMARY KEY,
  ROWID (nazwa_dzial)
  INCLUDING NEW VALUES
/
CREATE MATERIALIZED VIEW LOG ON nowy_nabor
  WITH PRIMARY KEY,
  ROWID (id_dzial, wynagrodz)
  INCLUDING NEW VALUES
/
CREATE MATERIALIZED VIEW mtw_dzial_wynagrodz
  REFRESH FAST ON COMMIT
  ENABLE QUERY REWRITE
  AS select d.nazwa_dzial,
       sum(n.wynagrodz) as wynagrodz_lacz
     from dzial d,
       nowy_nabor n
     where d.id_dzial = n.id_dzial
     group by d.nazwa_dzial;
