/* ================================================================
||   Program: create_nds4.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   13
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt ilustruje używanie języka NDS. 
|| ================================================================*/

-- Po debugowaniu umieść w komentarzu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

DECLARE
  -- Definicja struktury rekordowej.
  TYPE title_record IS RECORD
  ( item_title     VARCHAR2(60)
  , item_subtitle  VARCHAR2(60));
  -- Definicje zmiennych.  
  title_cursor  SYS_REFCURSOR;
  title_row     TITLE_RECORD;
  stmt          VARCHAR2(2000);
BEGIN
  -- Ustawianie instrukcji.
  stmt := 'SELECT  item_title, item_subtitle '
       || 'FROM    item '
       || 'WHERE   SUBSTR(item_title,1,12) = :input';
  
  -- Otwieranie i wczytywanie zawartości kursora dynamicznego. Potem kursor jest zamykany.
  OPEN title_cursor FOR stmt USING 'Harry Potter';
  LOOP
    FETCH title_cursor INTO title_row;
    EXIT WHEN title_cursor%NOTFOUND;
    dbms_output.put_line(
      '['||title_row.item_title||']['||title_row.item_subtitle||']');
  END LOOP;
  CLOSE title_cursor;
END;
/

