/* ================================================================
||   Program: get_bfilename.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   10
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt pokazuje, jak pobrać nazwę pliku 
||   z kolumny typu BFILENAME.
|| ================================================================*/

-- Po zakończeniu debugowania umieść w komentarzu.
SET ECHO ON
SET FEEDBACK ON
SET PAGESIZE 49999
SET SERVEROUTPUT ON SIZE 1000000

CREATE OR REPLACE FUNCTION get_bfilename
( table_name        VARCHAR2
, column_name       VARCHAR2
, primary_key_name  VARCHAR2
, primary_key_value VARCHAR2)
RETURN VARCHAR2 IS

  -- Definicja lokalizatora.
  locator           BFILE;

  -- Definicja aliasu i nazwy pliku.
  dir_alias VARCHAR2(255);
  directory VARCHAR2(255);
  file_name VARCHAR2(255);
  
  -- Definicja zmiennej lokalnej na potrzeby instrukcji NDS.
  stmt      VARCHAR2(2000);
  delimiter VARCHAR2(1) := '/';

  -- Definicja wyjątku lokalnego związanego z przekroczeniem limitu rozmiaru.
  directory_num EXCEPTION;
  PRAGMA EXCEPTION_INIT(directory_num,-22285);  

BEGIN

  -- Opakowanie instrukcji w blok anonimowy w celu utworzenia zmiennej typu OUT.
  stmt := 'BEGIN '
       || 'SELECT '||column_name||' '
       || 'INTO :locator '
       || 'FROM '||table_name||' '
       || 'WHERE '||primary_key_name||' = '||''''||primary_key_value||''';'
       || 'END;';

  -- Zwracanie wyniku z dynamicznej instrukcji SQL-a.
  EXECUTE IMMEDIATE stmt USING OUT locator;

  -- Sprawdzanie, czy lokalizator jest dostępny.
  IF locator IS NOT NULL THEN     
    dbms_lob.filegetname(locator,dir_alias,file_name);
  END IF;

  -- Zwracanie nazwy pliku.
  RETURN delimiter||LOWER(dir_alias)||delimiter||file_name;

EXCEPTION
  WHEN directory_num THEN
  RETURN NULL;

END get_bfilename;
/
