/* ================================================================
||   Program: create_insteadof_trigger.sql
||   Data:       2013-07-25
||   Książka:    Oracle Database 12c. Programowanie w języku PL/SQL
||   Rozdział:   12
||   Autor:  Michael McLaughlin
|| ----------------------------------------------------------------
||   Zawartość:
||   ---------
||   Ten skrypt ilustruje wyzwalacze zastępujące.
|| ================================================================*/

SET ECHO OFF
SET FEEDBACK ON
SET NULL '<Null>'
SET PAGESIZE 999
SET SERVEROUTPUT ON

CREATE OR REPLACE TRIGGER account_list_dml
  INSTEAD OF INSERT OR UPDATE OR DELETE ON account_list
  FOR EACH ROW
DECLARE
  -- Zmienna source.
  source VARCHAR2(10);
  -- source account_list.full_name%TYPE := :new.full_name;
  fname  VARCHAR2(43);
  mname  VARCHAR2(1);
  lname  VARCHAR2(43);
  -- Sprawdzanie, czy elementy zależne zostały usunięte.
  FUNCTION get_dependents (member_id NUMBER) RETURN BOOLEAN IS
    rows NUMBER := 0;
    CURSOR c (member_id_in NUMBER) IS
      SELECT COUNT(*) FROM contact WHERE member_id = member_id_in;
  BEGIN
    OPEN c (member_id);
    FETCH c INTO rows;
    IF rows > 0 THEN
      RETURN FALSE;
    ELSE
      RETURN TRUE;
    END IF;
  END get_dependents;
BEGIN
  
  IF INSERTING THEN -- Przy wstawianiu.
  
    RAISE_APPLICATION_ERROR(-20000,'Brak danych do wstawienia!');
  
  ELSIF UPDATING THEN -- Przy aktualizacji.
  
    -- Przypisywanie wartości do zmiennej source.
    source := :new.full_name;

    -- Parsowanie pełnego imienia i nazwiska w celu pobrania składowych.
    fname := LTRIM(REGEXP_SUBSTR(source,'(^|^ +)([[:alpha:]]+)',1));
    mname := REGEXP_SUBSTR(
               REGEXP_SUBSTR(
                 source,'( +)([[:alpha:]]+)(( +|. +))',1),'([[:alpha:]])',1);
    lname := REGEXP_SUBSTR(
               REGEXP_SUBSTR(
                 source,'( +)([[:alpha:]]+)( +$|$)',1),'([[:alpha:]]+)',1);
    
    -- Aktualizowanie imienia i nazwiska w tabeli bazowej.
    UPDATE contact
    SET    first_name = fname
    ,      middle_initial = mname
    ,      last_name = lname
    WHERE  contact_id = :old.contact_id;
    
  ELSIF DELETING THEN -- Przy usuwaniu.
  
    DELETE FROM contact WHERE member_id = :old.member_id;
    
    -- Gdy nie ma dzieci, wystarczy usunąć rodzica.
    IF get_dependents(:old.member_id) THEN
      DELETE FROM member WHERE member_id = :old.member_id;
    END IF;
    
  END IF;
  
END;
/
